/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc;

import java.util.List;
import wiremock.grpc.io.grpc.Configurator;
import wiremock.grpc.io.grpc.ConfiguratorRegistry;
import wiremock.grpc.io.grpc.Internal;
import wiremock.grpc.io.grpc.InternalConfigurator;
import wiremock.grpc.io.grpc.ManagedChannelBuilder;
import wiremock.grpc.io.grpc.ServerBuilder;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }

    public static int getConfiguratorsCallCountBeforeSet() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfiguratorsCallCountBeforeSet();
    }
}

