/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc.internal;

import java.util.concurrent.Executor;
import wiremock.com.google.common.annotations.VisibleForTesting;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.util.concurrent.ListenableFuture;
import wiremock.com.google.common.util.concurrent.SettableFuture;
import wiremock.grpc.io.grpc.CallOptions;
import wiremock.grpc.io.grpc.ClientStreamTracer;
import wiremock.grpc.io.grpc.InternalChannelz;
import wiremock.grpc.io.grpc.InternalLogId;
import wiremock.grpc.io.grpc.Metadata;
import wiremock.grpc.io.grpc.MethodDescriptor;
import wiremock.grpc.io.grpc.Status;
import wiremock.grpc.io.grpc.internal.ClientStream;
import wiremock.grpc.io.grpc.internal.ClientStreamListener;
import wiremock.grpc.io.grpc.internal.ClientTransport;
import wiremock.grpc.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error);
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

