/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc.netty;

import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import wiremock.com.google.common.annotations.VisibleForTesting;
import wiremock.grpc.io.grpc.Internal;
import wiremock.grpc.io.grpc.internal.ClientTransportFactory;
import wiremock.grpc.io.grpc.internal.SharedResourcePool;
import wiremock.grpc.io.grpc.internal.TransportTracer;
import wiremock.grpc.io.grpc.netty.InternalProtocolNegotiator;
import wiremock.grpc.io.grpc.netty.NettyChannelBuilder;
import wiremock.grpc.io.grpc.netty.ProtocolNegotiator;
import wiremock.grpc.io.grpc.netty.Utils;

@Internal
public final class InternalNettyChannelBuilder {
    public static void disableCheckAuthority(NettyChannelBuilder builder) {
        builder.disableCheckAuthority();
    }

    public static void enableCheckAuthority(NettyChannelBuilder builder) {
        builder.enableCheckAuthority();
    }

    public static void setProtocolNegotiatorFactory(NettyChannelBuilder builder, final ProtocolNegotiatorFactory protocolNegotiator) {
        builder.protocolNegotiatorFactory(new ProtocolNegotiator.ClientFactory(){

            @Override
            public ProtocolNegotiator newNegotiator() {
                return protocolNegotiator.buildProtocolNegotiator();
            }

            @Override
            public int getDefaultPort() {
                return 443;
            }
        });
    }

    public static void setProtocolNegotiatorFactory(NettyChannelBuilder builder, InternalProtocolNegotiator.ClientFactory protocolNegotiator) {
        builder.protocolNegotiatorFactory(protocolNegotiator);
    }

    public static void setStatsEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setStatsEnabled(value);
    }

    public static void setTracingEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setTracingEnabled(value);
    }

    public static void setStatsRecordStartedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordStartedRpcs(value);
    }

    public static void setStatsRecordFinishedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordFinishedRpcs(value);
    }

    public static void setStatsRecordRealTimeMetrics(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordRealTimeMetrics(value);
    }

    public static void setStatsRecordRetryMetrics(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordRetryMetrics(value);
    }

    public static void useNioTransport(NettyChannelBuilder builder) {
        builder.channelType(NioSocketChannel.class, InetSocketAddress.class);
        builder.eventLoopGroupPool(SharedResourcePool.forResource(Utils.NIO_WORKER_EVENT_LOOP_GROUP));
    }

    public static ClientTransportFactory buildTransportFactory(NettyChannelBuilder builder) {
        return builder.buildTransportFactory();
    }

    @VisibleForTesting
    public static void setTransportTracerFactory(NettyChannelBuilder builder, TransportTracer.Factory factory) {
        builder.setTransportTracerFactory(factory);
    }

    private InternalNettyChannelBuilder() {
    }

    public static interface ProtocolNegotiatorFactory {
        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator();
    }
}

