/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc.netty;

import io.netty.handler.ssl.SslContext;
import wiremock.com.google.common.base.Preconditions;
import wiremock.grpc.io.grpc.ChannelCredentials;
import wiremock.grpc.io.grpc.ExperimentalApi;
import wiremock.grpc.io.grpc.netty.GrpcSslContexts;
import wiremock.grpc.io.grpc.netty.NettyChannelCredentials;
import wiremock.grpc.io.grpc.netty.ProtocolNegotiators;

@ExperimentalApi(value="There is no plan to make this API stable, given transport API instability")
public final class NettySslContextChannelCredentials {
    private NettySslContextChannelCredentials() {
    }

    public static ChannelCredentials create(SslContext sslContext) {
        Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
        GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        return NettyChannelCredentials.create(ProtocolNegotiators.tlsClientFactory(sslContext, null));
    }
}

