/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc.netty;

import io.netty.handler.ssl.SslContext;
import wiremock.com.google.common.base.Preconditions;
import wiremock.grpc.io.grpc.ExperimentalApi;
import wiremock.grpc.io.grpc.ServerCredentials;
import wiremock.grpc.io.grpc.netty.GrpcSslContexts;
import wiremock.grpc.io.grpc.netty.NettyServerCredentials;
import wiremock.grpc.io.grpc.netty.ProtocolNegotiators;

@ExperimentalApi(value="There is no plan to make this API stable, given transport API instability")
public final class NettySslContextServerCredentials {
    private NettySslContextServerCredentials() {
    }

    public static ServerCredentials create(SslContext sslContext) {
        Preconditions.checkArgument(sslContext.isServer(), "Client SSL context can not be used for server");
        GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        return NettyServerCredentials.create(ProtocolNegotiators.serverTlsFactory(sslContext));
    }
}

