/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc.netty;

import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import wiremock.com.google.common.base.Preconditions;
import wiremock.grpc.io.grpc.Internal;
import wiremock.grpc.io.grpc.NameResolver;
import wiremock.grpc.io.grpc.NameResolverProvider;
import wiremock.grpc.io.grpc.netty.UdsNameResolver;

@Internal
public final class UdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "unix";

    @Override
    public UdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new UdsNameResolver(targetUri.getAuthority(), UdsNameResolverProvider.getTargetPathFromUri(targetUri), args);
        }
        return null;
    }

    static String getTargetPathFromUri(URI targetUri) {
        Preconditions.checkArgument(SCHEME.equals(targetUri.getScheme()), "scheme must be unix");
        String targetPath = targetUri.getPath();
        if (targetPath == null) {
            targetPath = Preconditions.checkNotNull(targetUri.getSchemeSpecificPart(), "targetPath");
        }
        return targetPath;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 3;
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

