/*
 * Decompiled with CFR 0.152.
 */
package wiremock.grpc.io.grpc.servlet.jakarta;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import wiremock.com.google.common.annotations.VisibleForTesting;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.util.concurrent.ListenableFuture;
import wiremock.grpc.io.grpc.Attributes;
import wiremock.grpc.io.grpc.ExperimentalApi;
import wiremock.grpc.io.grpc.ForwardingServerBuilder;
import wiremock.grpc.io.grpc.Internal;
import wiremock.grpc.io.grpc.InternalChannelz;
import wiremock.grpc.io.grpc.InternalInstrumented;
import wiremock.grpc.io.grpc.InternalLogId;
import wiremock.grpc.io.grpc.Metadata;
import wiremock.grpc.io.grpc.Server;
import wiremock.grpc.io.grpc.ServerBuilder;
import wiremock.grpc.io.grpc.ServerStreamTracer;
import wiremock.grpc.io.grpc.Status;
import wiremock.grpc.io.grpc.internal.GrpcUtil;
import wiremock.grpc.io.grpc.internal.InternalServer;
import wiremock.grpc.io.grpc.internal.ServerImplBuilder;
import wiremock.grpc.io.grpc.internal.ServerListener;
import wiremock.grpc.io.grpc.internal.ServerStream;
import wiremock.grpc.io.grpc.internal.ServerTransport;
import wiremock.grpc.io.grpc.internal.ServerTransportListener;
import wiremock.grpc.io.grpc.internal.SharedResourceHolder;
import wiremock.grpc.io.grpc.servlet.jakarta.GrpcServlet;
import wiremock.grpc.io.grpc.servlet.jakarta.ServletAdapter;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5066")
@NotThreadSafe
public final class ServletServerBuilder
extends ForwardingServerBuilder<ServletServerBuilder> {
    List<? extends ServerStreamTracer.Factory> streamTracerFactories;
    int maxInboundMessageSize = 0x400000;
    private final ServerImplBuilder serverImplBuilder = new ServerImplBuilder(this::buildTransportServers);
    private ScheduledExecutorService scheduler;
    private boolean internalCaller;
    private boolean usingCustomScheduler;
    private InternalServerImpl internalServer;

    @Override
    public Server build() {
        Preconditions.checkState(this.internalCaller, "build() method should not be called directly by an application");
        return super.build();
    }

    public ServletAdapter buildServletAdapter() {
        return new ServletAdapter(this.buildAndStart(), this.streamTracerFactories, this.maxInboundMessageSize);
    }

    public GrpcServlet buildServlet() {
        return new GrpcServlet(this.buildServletAdapter());
    }

    private ServerTransportListener buildAndStart() {
        Server server;
        try {
            this.internalCaller = true;
            server = this.build().start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.internalCaller = false;
        }
        if (!this.usingCustomScheduler) {
            this.scheduler = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
        }
        ServerTransportImpl serverTransport = new ServerTransportImpl(this.scheduler);
        final ServerTransportListener delegate = this.internalServer.serverListener.transportCreated(serverTransport);
        return new ServerTransportListener(){

            @Override
            public void streamCreated(ServerStream stream, String method, Metadata headers) {
                delegate.streamCreated(stream, method, headers);
            }

            @Override
            public Attributes transportReady(Attributes attributes) {
                return delegate.transportReady(attributes);
            }

            @Override
            public void transportTerminated() {
                server.shutdown();
                delegate.transportTerminated();
                if (!ServletServerBuilder.this.usingCustomScheduler) {
                    SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, ServletServerBuilder.this.scheduler);
                }
            }
        };
    }

    @VisibleForTesting
    InternalServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories");
        this.streamTracerFactories = streamTracerFactories;
        this.internalServer = new InternalServerImpl();
        return this.internalServer;
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    @Override
    public ServletServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS should be configured by the servlet container");
    }

    @Override
    public ServletServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument(bytes >= 0, "bytes must be >= 0");
        this.maxInboundMessageSize = bytes;
        return this;
    }

    public ServletServerBuilder scheduledExecutorService(ScheduledExecutorService scheduler) {
        this.scheduler = Preconditions.checkNotNull(scheduler, "scheduler");
        this.usingCustomScheduler = true;
        return this;
    }

    @VisibleForTesting
    static final class ServerTransportImpl
    implements ServerTransport {
        private final InternalLogId logId = InternalLogId.allocate(ServerTransportImpl.class, null);
        private final ScheduledExecutorService scheduler;

        ServerTransportImpl(ScheduledExecutorService scheduler) {
            this.scheduler = Preconditions.checkNotNull(scheduler, "scheduler");
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void shutdownNow(Status reason) {
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduler;
        }

        @Override
        public ListenableFuture<InternalChannelz.SocketStats> getStats() {
            return null;
        }

        @Override
        public InternalLogId getLogId() {
            return this.logId;
        }
    }

    private static final class InternalServerImpl
    implements InternalServer {
        ServerListener serverListener;

        InternalServerImpl() {
        }

        @Override
        public void start(ServerListener listener) {
            this.serverListener = listener;
        }

        @Override
        public void shutdown() {
            if (this.serverListener != null) {
                this.serverListener.serverShutdown();
            }
        }

        @Override
        public SocketAddress getListenSocketAddress() {
            return new SocketAddress(){

                public String toString() {
                    return "ServletServer";
                }
            };
        }

        @Override
        public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
            return null;
        }

        @Override
        public List<? extends SocketAddress> getListenSocketAddresses() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
            return null;
        }
    }
}

