/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.classic;

import wiremock.org.apache.hc.client5.http.HttpRoute;
import wiremock.org.apache.hc.client5.http.impl.classic.AbstractBackoff;
import wiremock.org.apache.hc.core5.pool.ConnPoolControl;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ExponentialBackoffManager
extends AbstractBackoff {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackoffManager.class);

    public ExponentialBackoffManager(ConnPoolControl<HttpRoute> connPerRoute) {
        super(connPerRoute);
    }

    @Override
    protected int getBackedOffPoolSize(int curr) {
        if (curr <= 1) {
            return 1;
        }
        int t = this.getTimeInterval().incrementAndGet();
        int result = Math.max(1, (int)Math.floor((double)curr / Math.pow(1.0 + this.getBackoffFactor().get(), t)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("curr={}, t={}, growthRate={}, result={}", new Object[]{curr, t, this.getBackoffFactor().get(), result});
        }
        return result;
    }

    @Override
    public void setBackoffFactor(double rate) {
        Args.check(rate > 0.0, "Growth rate must be greater than 0.0");
        this.getBackoffFactor().set(rate);
    }
}

