/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.server;

import wiremock.org.eclipse.jetty.http.BadMessageException;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import wiremock.org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.util.annotation.Name;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class HTTP2CServerConnectionFactory
extends HTTP2ServerConnectionFactory
implements ConnectionFactory.Upgrading {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2CServerConnectionFactory.class);

    public HTTP2CServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2c");
    }

    public HTTP2CServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(httpConfiguration, protocols);
        for (String p : protocols) {
            if (HTTP2ServerConnection.isSupportedProtocol(p)) continue;
            throw new IllegalArgumentException("Unsupported HTTP2 Protocol variant: " + p);
        }
    }

    @Override
    public boolean isAcceptable(String protocol, String tlsProtocol, String tlsCipher) {
        return false;
    }

    @Override
    public Connection upgradeConnection(Connector connector, EndPoint endPoint, MetaData.Request request, HttpFields.Mutable response101) throws BadMessageException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgrading {}{}{}", new Object[]{this, request, System.lineSeparator(), request.getFields()});
        }
        if (request.getContentLength() > 0L) {
            return null;
        }
        HTTP2ServerConnection connection = (HTTP2ServerConnection)this.newConnection(connector, endPoint);
        if (connection.upgrade(request, response101)) {
            return connection;
        }
        return null;
    }
}

