/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HeaderCopyingServerInterceptor
implements ServerInterceptor {
    public static final Context.Key<HttpHeaders> HTTP_HEADERS_CONTEXT_KEY = Context.key((String)"HTTP_HEADERS_CONTEXT_KEY");

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        HttpHeaders httpHeaders = HeaderCopyingServerInterceptor.buildHttpHeaders(headers);
        Context newContext = Context.current().withValue(HTTP_HEADERS_CONTEXT_KEY, (Object)httpHeaders);
        return Contexts.interceptCall((Context)newContext, call, (Metadata)headers, next);
    }

    private static HttpHeaders buildHttpHeaders(Metadata metadata) {
        List httpHeaderList = metadata.keys().stream().map(key -> {
            if (key.endsWith("-bin")) {
                return new HttpHeader(key, new String[]{Arrays.toString((byte[])metadata.get(Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER)))});
            }
            return new HttpHeader(key, new String[]{(String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))});
        }).collect(Collectors.toList());
        return new HttpHeaders(httpHeaderList);
    }
}

