/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.servlet.jakarta.GrpcServlet;
import io.grpc.servlet.jakarta.ServletAdapter;
import io.grpc.stub.ServerCalls;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.wiremock.grpc.internal.ClientStreamingServerCallHandler;
import org.wiremock.grpc.internal.JsonMessageConverter;
import org.wiremock.grpc.internal.UnaryServerCallHandler;

public class GrpcFilter
extends HttpFilter {
    private GrpcServlet grpcServlet;
    private final StubRequestHandler stubRequestHandler;

    public GrpcFilter(StubRequestHandler stubRequestHandler) {
        this.stubRequestHandler = stubRequestHandler;
    }

    public void loadFileDescriptors(List<Descriptors.FileDescriptor> fileDescriptors) {
        this.grpcServlet = new GrpcServlet(this.buildServices(fileDescriptors));
    }

    private List<BindableService> buildServices(List<Descriptors.FileDescriptor> fileDescriptors) {
        TypeRegistry.Builder typeRegistryBuilder = TypeRegistry.newBuilder();
        fileDescriptors.forEach(fileDescriptor -> fileDescriptor.getMessageTypes().forEach(arg_0 -> ((TypeRegistry.Builder)typeRegistryBuilder).add(arg_0)));
        TypeRegistry typeRegistry = typeRegistryBuilder.build();
        JsonMessageConverter jsonMessageConverter = new JsonMessageConverter(typeRegistry);
        return fileDescriptors.stream().flatMap(fileDescriptor -> fileDescriptor.getServices().stream()).map(serviceDescriptor -> () -> {
            ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)serviceDescriptor.getFullName());
            serviceDescriptor.getMethods().forEach(methodDescriptor -> builder.addMethod(GrpcFilter.buildMessageDescriptorInstance(serviceDescriptor, methodDescriptor), this.buildHandler((Descriptors.ServiceDescriptor)serviceDescriptor, (Descriptors.MethodDescriptor)methodDescriptor, jsonMessageConverter)));
            return builder.build();
        }).collect(Collectors.toUnmodifiableList());
    }

    private ServerCallHandler<DynamicMessage, DynamicMessage> buildHandler(Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor, JsonMessageConverter jsonMessageConverter) {
        return methodDescriptor.isClientStreaming() ? ServerCalls.asyncClientStreamingCall((ServerCalls.ClientStreamingMethod)new ClientStreamingServerCallHandler(this.stubRequestHandler, serviceDescriptor, methodDescriptor, jsonMessageConverter)) : ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new UnaryServerCallHandler(this.stubRequestHandler, serviceDescriptor, methodDescriptor, jsonMessageConverter));
    }

    private static MethodDescriptor<DynamicMessage, DynamicMessage> buildMessageDescriptorInstance(Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor) {
        return MethodDescriptor.newBuilder().setType(GrpcFilter.getMethodTypeFromDesc(methodDescriptor)).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceDescriptor.getFullName(), (String)methodDescriptor.getName())).setRequestMarshaller(ProtoUtils.marshaller((Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)methodDescriptor.getInputType()))).setResponseMarshaller(ProtoUtils.marshaller((Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)methodDescriptor.getOutputType()))).build();
    }

    private static MethodDescriptor.MethodType getMethodTypeFromDesc(Descriptors.MethodDescriptor methodDesc) {
        if (!methodDesc.isServerStreaming() && !methodDesc.isClientStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDesc.isServerStreaming() && !methodDesc.isClientStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        if (!methodDesc.isServerStreaming()) {
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        return MethodDescriptor.MethodType.BIDI_STREAMING;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ServletAdapter.isGrpc((HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ServerAddress.set(request.getScheme(), request.getLocalAddr(), request.getLocalPort());
        this.grpcServlet.service((ServletRequest)request, (ServletResponse)response);
    }

    public static class ServerAddress {
        private static final CompletableFuture<ServerAddress> instance = new CompletableFuture();
        final String scheme;
        final String hostname;
        final int port;

        public static void set(String scheme, String hostname, int port) {
            instance.complete(new ServerAddress(scheme, hostname, port));
        }

        public static ServerAddress get() {
            return (ServerAddress)Exceptions.uncheck(() -> instance.get(5L, TimeUnit.SECONDS), ServerAddress.class);
        }

        public ServerAddress(String scheme, String hostname, int port) {
            this.scheme = scheme;
            this.hostname = hostname;
            this.port = port;
        }
    }
}

