/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GrpcRequest
implements Request {
    private final String scheme;
    private final String host;
    private final int port;
    private final String serviceName;
    private final String methodName;
    private final String body;

    public GrpcRequest(String scheme, String host, int port, String serviceName, String methodName, String body) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.body = body;
    }

    public String getUrl() {
        return "/" + this.serviceName + "/" + this.methodName;
    }

    public String getAbsoluteUrl() {
        return this.scheme + "://" + this.host + ":" + this.port + this.getUrl();
    }

    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getClientIp() {
        return null;
    }

    public String getHeader(String key) {
        return null;
    }

    public HttpHeader header(String key) {
        return HttpHeader.absent((String)key);
    }

    public ContentTypeHeader contentTypeHeader() {
        return ContentTypeHeader.absent();
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.noHeaders();
    }

    public boolean containsHeader(String key) {
        return false;
    }

    public Set<String> getAllHeaderKeys() {
        return Collections.emptySet();
    }

    public QueryParameter queryParameter(String key) {
        return QueryParameter.absent((String)key);
    }

    public FormParameter formParameter(String key) {
        return FormParameter.absent((String)key);
    }

    public Map<String, FormParameter> formParameters() {
        return Collections.emptyMap();
    }

    public Map<String, Cookie> getCookies() {
        return Collections.emptyMap();
    }

    public byte[] getBody() {
        return Strings.bytesFromString((String)this.body);
    }

    public String getBodyAsString() {
        return this.body;
    }

    public String getBodyAsBase64() {
        return Encoding.encodeBase64((byte[])this.getBody());
    }

    public boolean isMultipart() {
        return false;
    }

    public Collection<Request.Part> getParts() {
        return Collections.emptyList();
    }

    public Request.Part getPart(String name) {
        return null;
    }

    public boolean isBrowserProxyRequest() {
        return false;
    }

    public Optional<Request> getOriginalRequest() {
        return Optional.empty();
    }

    public String getProtocol() {
        return "HTTP/2";
    }
}

