/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.dsl;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.ArrayList;
import java.util.List;
import org.wiremock.annotations.Beta;
import org.wiremock.grpc.dsl.GrpcResponseDefinitionBuilder;
import org.wiremock.grpc.dsl.WireMockGrpc;
import org.wiremock.grpc.internal.UrlUtils;

@Beta(justification="Incubating extension: https://github.com/wiremock/wiremock/issues/2383")
public class GrpcStubMappingBuilder {
    private String method;
    private GrpcResponseDefinitionBuilder responseBuilder;
    private List<StringValuePattern> requestMessageJsonPatterns = new ArrayList<StringValuePattern>();

    public GrpcStubMappingBuilder(String method) {
        this.method = method;
    }

    public GrpcStubMappingBuilder withRequestMessage(StringValuePattern requestMessageJsonPattern) {
        this.requestMessageJsonPatterns.add(requestMessageJsonPattern);
        return this;
    }

    public GrpcStubMappingBuilder willReturn(GrpcResponseDefinitionBuilder responseBuilder) {
        this.responseBuilder = responseBuilder;
        return this;
    }

    public GrpcStubMappingBuilder willReturn(WireMockGrpc.Status status, String statusReason) {
        this.responseBuilder = new GrpcResponseDefinitionBuilder(status, statusReason);
        return this;
    }

    public GrpcStubMappingBuilder willReturn(Fault fault) {
        this.responseBuilder = new GrpcResponseDefinitionBuilder(fault);
        return this;
    }

    public GrpcStubMappingBuilder withFixedDelay(long milliseconds) {
        this.responseBuilder.withFixedDelay(milliseconds);
        return this;
    }

    public GrpcStubMappingBuilder withDelay(DelayDistribution delay) {
        this.responseBuilder.withRandomDelay(delay);
        return this;
    }

    public GrpcStubMappingBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma) {
        return this.withDelay((DelayDistribution)new LogNormal(medianMilliseconds, sigma));
    }

    public GrpcStubMappingBuilder withUniformRandomDelay(int lowerMilliseconds, int upperMilliseconds) {
        return this.withDelay((DelayDistribution)new UniformDistribution(lowerMilliseconds, upperMilliseconds));
    }

    public StubMapping build(String serviceName) {
        MappingBuilder mappingBuilder = WireMock.post((UrlPattern)UrlUtils.grpcUrlPath(serviceName, this.method));
        this.requestMessageJsonPatterns.forEach(arg_0 -> ((MappingBuilder)mappingBuilder).withRequestBody(arg_0));
        return mappingBuilder.willReturn(this.responseBuilder.build()).build();
    }
}

