/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.util.JsonFormat;

public class JsonMessageConverter {
    private final JsonFormat.Printer jsonPrinter;
    private final JsonFormat.Parser jsonParser;

    public JsonMessageConverter(TypeRegistry typeRegistry) {
        this.jsonPrinter = JsonFormat.printer().usingTypeRegistry(typeRegistry);
        this.jsonParser = JsonFormat.parser().usingTypeRegistry(typeRegistry);
    }

    public String toJson(MessageOrBuilder message) {
        return (String)Exceptions.uncheck(() -> this.jsonPrinter.print(message), String.class);
    }

    public <T extends Message, B extends Message.Builder> T toMessage(String json, B builder) {
        Exceptions.uncheck(() -> this.jsonParser.merge(json, builder));
        return (T)builder.build();
    }
}

