/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.multipart.PartParser;
import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class WireMockHttpServletRequestAdapter
implements com.github.tomakehurst.wiremock.http.Request {
    public static final String ORIGINAL_REQUEST_KEY = "wiremock.ORIGINAL_REQUEST";
    private final HttpServletRequest request;
    private byte[] cachedBody;
    private final Supplier<Map<String, QueryParameter>> cachedQueryParams;
    private final Map<String, FormParameter> cachedFormParameters;
    private final boolean browserProxyingEnabled;
    private final String urlPrefixToRemove;
    private final JettyHttpUtils utils;
    private Collection<Request.Part> cachedMultiparts;

    public WireMockHttpServletRequestAdapter(HttpServletRequest request, String urlPrefixToRemove, boolean browserProxyingEnabled, JettyHttpUtils utils) {
        this.request = request;
        this.urlPrefixToRemove = urlPrefixToRemove;
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.utils = utils;
        this.cachedQueryParams = Suppliers.memoize(() -> Urls.splitQuery((String)request.getQueryString()));
        this.cachedFormParameters = this.getFormParameters(request);
    }

    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!Strings.isNullOrEmpty((String)contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!Strings.isNullOrEmpty((String)this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (String)(Strings.isNullOrEmpty((String)this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    public RequestMethod getMethod() {
        return RequestMethod.fromString((String)this.request.getMethod().toUpperCase());
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getHost() {
        return this.request.getServerName();
    }

    public int getPort() {
        return this.request.getServerPort();
    }

    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && !forwardedForHeader.isEmpty()) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    public byte[] getBody() {
        if (this.cachedBody == null) {
            try {
                byte[] body = this.request.getInputStream().readAllBytes();
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped((byte[])body);
                this.cachedBody = isGzipped ? Gzip.unGzip((byte[])body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.contentTypeHeader();
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return StandardCharsets.UTF_8;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    public String getBodyAsString() {
        return Strings.stringFromBytes((byte[])this.getBody(), (Charset)this.encodingFromContentTypeHeaderOrUtf8());
    }

    public String getBodyAsBase64() {
        return Encoding.encodeBase64((byte[])this.getBody());
    }

    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    public HttpHeader header(String key) {
        if (this.request.getHeader(key) == null) {
            return HttpHeader.absent((String)key);
        }
        ArrayList valueList = Collections.list(this.request.getHeaders(key));
        if (valueList.isEmpty()) {
            return HttpHeader.empty((String)key);
        }
        return new HttpHeader(key, valueList);
    }

    public ContentTypeHeader contentTypeHeader() {
        String firstValue = this.getHeader("Content-Type");
        return firstValue == null ? ContentTypeHeader.absent() : new ContentTypeHeader(firstValue);
    }

    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    public HttpHeaders getHeaders() {
        if (this.request instanceof Request) {
            return WireMockHttpServletRequestAdapter.getHeadersLinear((Request)this.request);
        }
        return this.getHeadersQuadratic();
    }

    private static HttpHeaders getHeadersLinear(Request request) {
        List headers = request.getHeaders().stream().map(field -> HttpHeader.httpHeader((String)field.getName(), (String[])new String[]{field.getValue()})).collect(Collectors.toList());
        return new HttpHeaders(headers);
    }

    private HttpHeaders getHeadersQuadratic() {
        ArrayList<HttpHeader> headerList = new ArrayList<HttpHeader>();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add((String)headerNames.nextElement());
        }
        return headerKeys;
    }

    public Map<String, com.github.tomakehurst.wiremock.http.Cookie> getCookies() {
        Cookie[] cookies;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Cookie cookie : cookies = (Cookie[])ParameterUtils.getFirstNonNull((Object)this.request.getCookies(), (Object)new Cookie[0])) {
            builder.put((Object)cookie.getName(), (Object)cookie.getValue());
        }
        return Maps.transformValues((Map)builder.build().asMap(), input -> new com.github.tomakehurst.wiremock.http.Cookie(null, List.copyOf(input)));
    }

    public QueryParameter queryParameter(String key) {
        Map<String, QueryParameter> queryParams = this.cachedQueryParams.get();
        return (QueryParameter)ParameterUtils.getFirstNonNull((Object)queryParams.get(key), (Object)QueryParameter.absent((String)key));
    }

    public FormParameter formParameter(String key) {
        return (FormParameter)ParameterUtils.getFirstNonNull((Object)this.cachedFormParameters.get(key), (Object)FormParameter.absent((String)key));
    }

    public Map<String, FormParameter> formParameters() {
        return this.cachedFormParameters;
    }

    public boolean isBrowserProxyRequest() {
        if (!this.browserProxyingEnabled || !JettyHttpUtils.isJetty()) {
            return false;
        }
        return this.utils.isBrowserProxyRequest(this.request);
    }

    public Collection<Request.Part> getParts() {
        if (!this.isMultipart()) {
            return null;
        }
        if (this.cachedMultiparts == null) {
            this.cachedMultiparts = PartParser.parseFrom((com.github.tomakehurst.wiremock.http.Request)this);
        }
        return this.cachedMultiparts.isEmpty() ? null : this.cachedMultiparts;
    }

    public boolean isMultipart() {
        String header = this.getHeader("Content-Type");
        return header != null && header.matches("(?i)^\\s*multipart/.*");
    }

    public Request.Part getPart(String name) {
        if (Strings.isNullOrEmpty((String)name) || this.cachedMultiparts == null && this.getParts() == null) {
            return null;
        }
        return this.cachedMultiparts.stream().filter(part -> name.equals(part.getName())).findFirst().orElse(null);
    }

    public Optional<com.github.tomakehurst.wiremock.http.Request> getOriginalRequest() {
        com.github.tomakehurst.wiremock.http.Request originalRequest = (com.github.tomakehurst.wiremock.http.Request)this.request.getAttribute(ORIGINAL_REQUEST_KEY);
        return Optional.ofNullable(originalRequest);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    private Map<String, FormParameter> getFormParameters(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.contains("application/x-www-form-urlencoded")) {
            return Collections.emptyMap();
        }
        MultiMap formParameterMultimap = new MultiMap();
        String characterEncoding = request.getCharacterEncoding();
        Charset charset = characterEncoding != null ? Charset.forName(characterEncoding) : Charset.defaultCharset();
        UrlEncoded.decodeTo((String)this.getBodyAsString(), (MultiMap)formParameterMultimap, (Charset)charset);
        return formParameterMultimap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new FormParameter((String)entry.getKey(), (List)entry.getValue())));
    }
}

