/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class NoFaultInjector
implements FaultInjector {
    private final HttpServletResponse httpServletResponse;

    public NoFaultInjector(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public void connectionResetByPeer() {
        this.sendError();
    }

    public void emptyResponseAndCloseConnection() {
        this.sendError();
    }

    public void malformedResponseChunk() {
        this.sendError();
    }

    public void randomDataAndCloseConnection() {
        this.sendError();
    }

    private void sendError() {
        this.httpServletResponse.setStatus(418);
        try {
            this.httpServletResponse.getWriter().write("No fault injector is configured!");
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }
}

