/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.servlet.NotImplementedContainer;
import com.github.tomakehurst.wiremock.servlet.WarConfiguration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;

public class WireMockWebContextListener
implements ServletContextListener {
    private static final String APP_CONTEXT_KEY = "WireMockApp";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        boolean verboseLoggingEnabled = Boolean.parseBoolean((String)ParameterUtils.getFirstNonNull((Object)context.getInitParameter("verboseLoggingEnabled"), (Object)"true"));
        WireMockApp wireMockApp = new WireMockApp((Options)new WarConfiguration(context), (Container)new NotImplementedContainer());
        context.setAttribute(APP_CONTEXT_KEY, (Object)wireMockApp);
        context.setAttribute(StubRequestHandler.class.getName(), (Object)wireMockApp.buildStubRequestHandler());
        context.setAttribute(AdminRequestHandler.class.getName(), (Object)wireMockApp.buildAdminRequestHandler());
        context.setAttribute("Notifier", (Object)new Slf4jNotifier(verboseLoggingEnabled));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

