/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.Callback;

public class HttpProxyDetectingHandler
extends Handler.Abstract {
    public static final String IS_HTTP_PROXY_REQUEST_ATTRIBUTE = "wiremock.isHttpProxyRequest";
    private final ServerConnector httpConnector;

    public HttpProxyDetectingHandler(ServerConnector httpConnector) {
        this.httpConnector = httpConnector;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        int httpPort = this.httpConnector.getLocalPort();
        if (httpPort != request.getHttpURI().getPort() && "http".equals(request.getHttpURI().getScheme())) {
            request.setAttribute(IS_HTTP_PROXY_REQUEST_ATTRIBUTE, (Object)true);
        }
        return false;
    }
}

