/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectableChannelEndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractMetaDataConnection;
import org.eclipse.jetty.server.Response;

class Jetty12HttpUtils
implements JettyHttpUtils {
    Jetty12HttpUtils() {
    }

    public Response unwrapResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return (Response)unwrapped;
        }
        if (httpServletResponse instanceof ServletApiResponse) {
            Response unwrapped = ((ServletApiResponse)httpServletResponse).getResponse();
            return unwrapped;
        }
        return (Response)httpServletResponse;
    }

    public Socket socket(Response response) {
        AbstractMetaDataConnection connectionMetaData = (AbstractMetaDataConnection)response.getRequest().getConnectionMetaData();
        SelectableChannelEndPoint ep = (SelectableChannelEndPoint)connectionMetaData.getEndPoint();
        return ((SocketChannel)ep.getChannel()).socket();
    }

    public Socket tlsSocket(Response response) {
        AbstractMetaDataConnection connectionMetaData = (AbstractMetaDataConnection)response.getRequest().getConnectionMetaData();
        SslConnection.SslEndPoint sslEndpoint = (SslConnection.SslEndPoint)connectionMetaData.getEndPoint();
        SelectableChannelEndPoint endpoint = (SelectableChannelEndPoint)sslEndpoint.getSslConnection().getEndPoint();
        return ((SocketChannel)endpoint.getChannel()).socket();
    }

    public void setStatusWithReason(int status, String reason, HttpServletResponse httpServletResponse) {
        httpServletResponse.setStatus(status);
    }

    public EndPoint unwrapEndPoint(Response jettyResponse) {
        AbstractMetaDataConnection connectionMetaData = (AbstractMetaDataConnection)jettyResponse.getRequest().getConnectionMetaData();
        return connectionMetaData.getEndPoint();
    }

    public boolean isBrowserProxyRequest(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute("wiremock.isHttpsProxyRequest")) || Boolean.TRUE.equals(request.getAttribute("wiremock.isHttpProxyRequest"));
    }
}

