/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ResourceUtil;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty.JettyFaultInjectorFactory;
import com.github.tomakehurst.wiremock.jetty.JettyHttpServer;
import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import com.github.tomakehurst.wiremock.jetty11.Jetty11Utils;
import com.github.tomakehurst.wiremock.jetty11.SslContexts;
import com.github.tomakehurst.wiremock.jetty12.HttpProxyDetectingHandler;
import com.github.tomakehurst.wiremock.jetty12.HttpsProxyDetectingHandler;
import com.github.tomakehurst.wiremock.jetty12.Jetty12HttpUtils;
import com.github.tomakehurst.wiremock.jetty12.ManInTheMiddleSslConnectHandler;
import com.github.tomakehurst.wiremock.jetty12.NotFoundHandler;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.servlet.NotMatchedServlet;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import jakarta.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class Jetty12HttpServer
extends JettyHttpServer {
    private ServerConnector mitmProxyConnector;

    public Jetty12HttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        super(options, adminRequestHandler, stubRequestHandler);
    }

    protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
        HttpConfiguration httpConfig = Jetty11Utils.createHttpConfig((JettySettings)jettySettings);
        ConnectionFactory[] connectionFactories = (ConnectionFactory[])Stream.of(new HttpConnectionFactory(httpConfig), this.options.getHttp2PlainDisabled() ? null : new HTTP2CServerConnectionFactory(httpConfig)).filter(Objects::nonNull).toArray(ConnectionFactory[]::new);
        return Jetty11Utils.createServerConnector((Server)this.jettyServer, (String)bindAddress, (JettySettings)jettySettings, (int)port, (NetworkTrafficListener)listener, (ConnectionFactory[])connectionFactories);
    }

    protected ServerConnector createHttpsConnector(String bindAddress, HttpsSettings httpsSettings, JettySettings jettySettings, NetworkTrafficListener listener) {
        ConnectionFactory[] connectionFactories;
        HttpConfiguration httpConfig = Jetty11Utils.createHttpConfig((JettySettings)jettySettings);
        if (!this.options.getHttp2TlsDisabled()) {
            SslContextFactory.Server http2SslContextFactory = SslContexts.buildHttp2SslContextFactory((HttpsSettings)httpsSettings);
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfig);
            try {
                ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, alpn.getProtocol());
                connectionFactories = new ConnectionFactory[]{ssl, alpn, h2, http};
            }
            catch (IllegalStateException e) {
                SslConnectionFactory ssl = new SslConnectionFactory(http2SslContextFactory, http.getProtocol());
                connectionFactories = new ConnectionFactory[]{ssl, http};
            }
        } else {
            SslContextFactory.Server sslContextFactory = SslContexts.buildHttp1_1SslContextFactory((HttpsSettings)httpsSettings);
            SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, "http/1.1");
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            connectionFactories = new ConnectionFactory[]{ssl, http};
        }
        return Jetty11Utils.createServerConnector((Server)this.jettyServer, (String)bindAddress, (JettySettings)jettySettings, (int)httpsSettings.port(), (NetworkTrafficListener)listener, (ConnectionFactory[])connectionFactories);
    }

    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
        if (options.browserProxySettings().enabled()) {
            SslConnectionFactory ssl = new SslConnectionFactory(SslContexts.buildManInTheMiddleSslContextFactory((HttpsSettings)options.httpsSettings(), (BrowserProxySettings)options.browserProxySettings(), (Notifier)options.notifier()), HttpVersion.HTTP_1_1.asString());
            JettySettings jettySettings = options.jettySettings();
            HttpConfiguration httpConfig = Jetty11Utils.createHttpConfig((JettySettings)jettySettings);
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            this.mitmProxyConnector = new NetworkTrafficServerConnector(jettyServer, null, null, null, 2, 2, new ConnectionFactory[]{ssl, http});
            this.mitmProxyConnector.setPort(0);
            this.mitmProxyConnector.setShutdownIdleTimeout(jettySettings.getShutdownIdleTimeout().orElse(100L).longValue());
            jettyServer.addConnector((Connector)this.mitmProxyConnector);
        }
    }

    protected Handler createHandler(final Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(adminContext, stubRequestHandler, options.filesRoot().child("__files"), options.getAsynchronousResponseSettings(), options.getChunkedEncodingPolicy(), options.getStubCorsEnabled(), options.browserProxySettings().enabled(), notifier);
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        Handler.Abstract asyncTimeoutSettingHandler = new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) {
                if (request instanceof ServletContextRequest) {
                    ServletContextRequest r = (ServletContextRequest)request;
                    r.getState().setTimeout(options.timeout());
                }
                return false;
            }
        };
        handlers.addAll(Arrays.asList(this.extensionHandlers()));
        handlers.add((Handler)adminContext);
        handlers.add((Handler)asyncTimeoutSettingHandler);
        if (options.getGzipDisabled()) {
            handlers.add((Handler)mockServiceContext);
        } else {
            this.addGZipHandler(mockServiceContext, handlers);
        }
        if (options.browserProxySettings().enabled()) {
            handlers.add(0, (Handler)new HttpProxyDetectingHandler(this.httpConnector));
            handlers.add(0, (Handler)new HttpsProxyDetectingHandler(this.mitmProxyConnector));
            handlers.add(0, (Handler)new ManInTheMiddleSslConnectHandler(this.mitmProxyConnector));
        }
        return new Handler.Sequence(handlers);
    }

    protected void decorateAdminServiceContextBeforeConfig(ServletContextHandler adminServiceContext) {
    }

    protected void decorateAdminServiceContextAfterConfig(ServletContextHandler adminServiceContext) {
    }

    private void addCorsFilter(ServletContextHandler context) {
        context.addFilter(this.buildCorsFilter(), "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler();
        adminContext.setServer(this.jettyServer);
        adminContext.setContextPath("/__admin");
        this.decorateAdminServiceContextBeforeConfig(adminContext);
        adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.toLowerCase().contains("android")) {
            adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", "assets");
        } else {
            adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", ResourceUtil.getResource(JettyHttpServer.class, (String)"assets").toString());
        }
        ResourceUtil.getResource(JettyHttpServer.class, (String)"assets/swagger-ui/index.html");
        adminContext.setWelcomeFiles(new String[]{"index.html", "index.jsp", "swagger-ui/index.html"});
        adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder swaggerUiServletHolder = adminContext.addServlet(DefaultServlet.class, "/swagger-ui/*");
        swaggerUiServletHolder.setAsyncSupported(false);
        adminContext.addServlet(DefaultServlet.class, "/recorder/*");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)notifier);
        adminContext.setAttribute(MultipartRequestConfigurer.KEY, (Object)this.buildMultipartRequestConfigurer());
        adminContext.addServlet(NotMatchedServlet.class, "/not-matched");
        this.addCorsFilter(adminContext);
        this.decorateAdminServiceContextAfterConfig(adminContext);
        return adminContext;
    }

    private ServletContextHandler addMockServiceContext(ServletContextHandler adminContext, StubRequestHandler stubRequestHandler, FileSource fileSource, AsynchronousResponseSettings asynchronousResponseSettings, Options.ChunkedEncodingPolicy chunkedEncodingPolicy, boolean stubCorsEnabled, boolean browserProxyingEnabled, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler();
        mockServiceContext.setServer(this.jettyServer);
        mockServiceContext.setContextPath("/");
        this.decorateMockServiceContextBeforeConfig(mockServiceContext);
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", fileSource.getPath());
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        Jetty12HttpUtils utils = new Jetty12HttpUtils();
        mockServiceContext.setAttribute(JettyHttpUtils.class.getName(), (Object)utils);
        mockServiceContext.setAttribute(JettyFaultInjectorFactory.class.getName(), (Object)new JettyFaultInjectorFactory((JettyHttpUtils)utils));
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)notifier);
        mockServiceContext.setAttribute(Options.ChunkedEncodingPolicy.class.getName(), (Object)chunkedEncodingPolicy);
        mockServiceContext.setAttribute("browserProxyingEnabled", (Object)browserProxyingEnabled);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitOrder(1);
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("FaultHandlerFactoryClass", JettyFaultInjectorFactory.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        if (asynchronousResponseSettings.isEnabled()) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(asynchronousResponseSettings.getThreads());
            mockServiceContext.setAttribute(WireMockHandlerDispatchingServlet.ASYNCHRONOUS_RESPONSE_EXECUTOR, (Object)this.scheduledExecutorService);
        }
        mockServiceContext.setAttribute(MultipartRequestConfigurer.KEY, (Object)this.buildMultipartRequestConfigurer());
        MimeTypes.Mutable mimeTypes = mockServiceContext.getMimeTypes();
        mimeTypes.addMimeMapping("*", "application/json");
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        NotFoundHandler errorHandler = new NotFoundHandler(adminContext);
        mockServiceContext.setErrorHandler((Request.Handler)errorHandler);
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        if (stubCorsEnabled) {
            this.addCorsFilter(mockServiceContext);
        }
        this.decorateMockServiceContextAfterConfig(mockServiceContext);
        return mockServiceContext;
    }

    protected void decorateMockServiceContextBeforeConfig(ServletContextHandler mockServiceContext) {
    }

    protected void decorateMockServiceContextAfterConfig(ServletContextHandler mockServiceContext) {
    }

    private void addGZipHandler(ServletContextHandler mockServiceContext, List<Handler> handlers) {
        try {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.addIncludedMethods(GZIPPABLE_METHODS);
            gzipHandler.setHandler((Handler)mockServiceContext);
            gzipHandler.setVary(null);
            handlers.add((Handler)gzipHandler);
        }
        catch (Exception e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    private FilterHolder buildCorsFilter() {
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameters(Map.of("chainPreflight", "false", "allowedOrigins", "*", "allowedHeaders", "*", "allowedMethods", "OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        return filterHolder;
    }
}

