/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class CookieMatchingAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void matchesOnWellFormedCookie() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/good/cookie")).withCookie("my_cookie", WireMock.containing((String)"mycookievalue")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/good/cookie", TestHttpHeader.withHeader("Cookie", "my_cookie=xxx-mycookievalue-xxx"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesWhenMultipleCookiesAreSentAndRequired() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/good/cookies")).withCookie("my_cookie", WireMock.containing((String)"mycookievalue")).withCookie("my_other_cookie", WireMock.equalTo((String)"exact-other-value")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/good/cookies", TestHttpHeader.withHeader("Cookie", "my_cookie=xxx-mycookievalue-xxx; my_other_cookie=exact-other-value; irrelevant_cookie=whatever"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotMatchWhenExpectedCookieIsAbsent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/missing/cookie")).withCookie("my_cookie", WireMock.containing((String)"mycookievalue")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/missing/cookie", TestHttpHeader.withHeader("Cookie", "the_wrong_cookie=xxx-mycookievalue-xxx"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotMatchWhenExpectedCookieHasTheWrongValue() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/bad/cookie")).withCookie("my_cookie", WireMock.containing((String)"mycookievalue")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/bad/cookie", TestHttpHeader.withHeader("Cookie", "my_cookie=youwontfindthis"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotMatchWhenExpectedCookieIsMalformed() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/very-bad/cookie")).withCookie("my_cookie", WireMock.containing((String)"mycookievalue")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/very-bad/cookie", TestHttpHeader.withHeader("Cookie", "my_cookieyouwontfindthis;;sldfjskldjf%%"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesWhenRequiredAbsentCookieIsAbsent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/absent/cookie")).withCookie("not_this_cookie", WireMock.absent()).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/absent/cookie", TestHttpHeader.withHeader("Cookie", "my_cookie=xxx-mycookievalue-xxx; my_other_cookie=exact-other-value; irrelevant_cookie=whatever"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotMatchWhenRequiredAbsentCookieIsPresent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/absent/cookie")).withCookie("my_cookie", WireMock.absent()).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/absent/cookie", TestHttpHeader.withHeader("Cookie", "my_cookie=xxx-mycookievalue-xxx; my_other_cookie=exact-other-value; irrelevant_cookie=whatever"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void revealsCookiesInLoggedRequests() {
        testClient.get("/good/cookies", TestHttpHeader.withHeader("Cookie", "my_cookie=xxx-mycookievalue-xxx; my_other_cookie=exact-other-value; irrelevant_cookie=whatever"));
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/good/cookies")));
        MatcherAssert.assertThat((Object)requests.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(((LoggedRequest)requests.get(0)).getCookies().keySet(), (Matcher)Matchers.hasItem((Object)"my_other_cookie"));
    }

    @Test
    public void matchesWhenRequiredCookieSentAsDuplicate() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookie")).withCookie("my_cookie", WireMock.containing((String)"mycookievalue")).withCookie("my_other_cookie", WireMock.equalTo((String)"value-2")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/duplicate/cookie", TestHttpHeader.withHeader("Cookie", "my_cookie=xxx-mycookievalue-xxx; my_other_cookie=value-1; my_other_cookie=value-2"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

