/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CrossOriginTest {

    @Nested
    public static class Disabled {
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort()).build();
        WireMockTestClient testClient;

        @BeforeEach
        public void init() {
            this.testClient = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        public void doesNotSendCorsHeadersInResponseToStubOPTIONSQuery() {
            this.wm.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/cors")).willReturn(WireMock.ok()));
            WireMockResponse response = this.testClient.options("/cors", TestHttpHeader.withHeader("Origin", "http://my.corp.com"), TestHttpHeader.withHeader("Access-Control-Request-Method", "POST"));
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.firstHeader("Access-Control-Allow-Origin"), (Matcher)Matchers.nullValue());
        }
    }

    @Nested
    public static class Enabled {
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().stubCorsEnabled(true)).build();
        WireMockTestClient testClient;

        @BeforeEach
        public void init() {
            this.testClient = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        public void sendsCorsHeadersInResponseToAdminOPTIONSQuery() {
            WireMockResponse response = this.testClient.options("/__admin/", TestHttpHeader.withHeader("Origin", "http://my.corp.com"), TestHttpHeader.withHeader("Access-Control-Request-Method", "POST"));
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.firstHeader("Access-Control-Allow-Origin"), (Matcher)Matchers.is((Object)"http://my.corp.com"));
            MatcherAssert.assertThat((Object)response.firstHeader("Access-Control-Allow-Methods"), (Matcher)Matchers.is((Object)"OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        }

        @Test
        public void sendsCorsHeadersInResponseToStubOPTIONSQuery() {
            this.wm.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/cors")).willReturn(WireMock.ok()));
            WireMockResponse response = this.testClient.options("/cors", TestHttpHeader.withHeader("Origin", "http://my.corp.com"), TestHttpHeader.withHeader("Access-Control-Request-Method", "POST"));
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.firstHeader("Access-Control-Allow-Origin"), (Matcher)Matchers.is((Object)"http://my.corp.com"));
            MatcherAssert.assertThat((Object)response.firstHeader("Access-Control-Allow-Methods"), (Matcher)Matchers.is((Object)"OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        }
    }
}

