/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class DateHeaderAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void returnsOnlyStubbedDateHeader() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stubbed/dateheader")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Date", new String[]{"Sun, 06 Nov 1994 08:49:37 GMT"})));
        WireMockResponse response = testClient.get("/stubbed/dateheader", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.headers().get((Object)"Date"), (Matcher)Matchers.contains((Object[])new String[]{"Sun, 06 Nov 1994 08:49:37 GMT"}));
    }

    @Test
    public void returnsNoDateHeaderIfNotStubbed() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/nodateheader")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/nodateheader", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.headers().get((Object)"Date"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }
}

