/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class ExtensionFactoryTest {
    WireMockServer wm;
    WireMockTestClient client;

    @AfterEach
    void stopServer() {
        if (this.wm != null) {
            this.wm.stop();
        }
    }

    @Test
    void injectsCoreServicesOnConstructionByFactory() {
        this.initialiseWireMockServer(WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).stubCorsEnabled(true).templatingEnabled(false).extensions(new ExtensionFactory[]{services -> List.of(new MiscInfoApi(services.getAdmin(), services.getOptions(), services.getStores(), services.getFiles(), services.getExtensions()))}));
        this.client.get("/something", new TestHttpHeader[0]);
        this.client.get("/something", new TestHttpHeader[0]);
        String content = this.client.get("/__admin/misc-info", new TestHttpHeader[0]).content();
        MatcherAssert.assertThat((Object)content, (Matcher)JsonMatchers.jsonPartEquals((String)"example1", (Object)"Example 1"));
        MatcherAssert.assertThat((Object)content, (Matcher)JsonMatchers.jsonPartMatches((String)"fileSourcePath", (Matcher)Matchers.endsWith((String)("test-file-root" + File.separator + "__files"))));
        MatcherAssert.assertThat((Object)content, (Matcher)JsonMatchers.jsonPartEquals((String)"requestCount", (Object)2));
        MatcherAssert.assertThat((Object)content, (Matcher)JsonMatchers.jsonPartEquals((String)"stubCorsEnabled", (Object)true));
        MatcherAssert.assertThat((Object)content, (Matcher)JsonMatchers.jsonPartEquals((String)"extensionCount", (Object)3));
    }

    @Test
    void usesExtensionFactoryLoadedViaServiceLoader() {
        this.initialiseWireMockServer(WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).templatingEnabled(false));
        this.wm.stubFor(WireMock.get((String)"/transform-this").willReturn(WireMock.noContent().withTransformers(new String[]{"loader-test"})));
        this.client.get("/just-count-this", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.client.get("/transform-this", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Request count 1"));
    }

    @Test
    void usesExtensionInstanceLoadedViaServiceLoader() {
        this.initialiseWireMockServer(WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).templatingEnabled(false));
        this.wm.stubFor(WireMock.get((String)"/transform-this").willReturn(WireMock.noContent().withTransformers(new String[]{"instance-loader-test"})));
        MatcherAssert.assertThat((Object)this.client.get("/transform-this", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Expected stuff"));
    }

    private void initialiseWireMockServer(WireMockConfiguration options) {
        this.wm = new WireMockServer((Options)options);
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    public static class MiscInfoApi
    implements AdminApiExtension {
        private final Admin admin;
        private final Options options;
        private final Stores stores;
        private final FileSource fileSource;
        private final Extensions extensions;

        public MiscInfoApi(Admin admin, Options options, Stores stores, FileSource fileSource, Extensions extensions) {
            this.admin = admin;
            this.options = options;
            this.stores = stores;
            this.fileSource = fileSource;
            this.extensions = extensions;
        }

        public String getName() {
            return "request-counter";
        }

        public void contributeAdminApiRoutes(Router router) {
            router.add(RequestMethod.GET, "/misc-info", (ignored, serveEvent, pathParams) -> {
                String example1 = Strings.stringFromBytes((byte[])((byte[])this.stores.getFilesBlobStore().get((Object)"plain-example1.txt").get()));
                String fileSourcePath = this.fileSource.getPath();
                int requestCount = this.admin.getServeEvents().getRequests().size();
                return ResponseDefinition.okForJson(Map.of("example1", example1, "fileSourcePath", fileSourcePath, "requestCount", requestCount, "stubCorsEnabled", this.options.getStubCorsEnabled(), "extensionCount", this.extensions.getCount()));
            });
        }
    }
}

