/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.Http2ClientFactory;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class Http2AcceptanceTest {
    @RegisterExtension
    public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).build();

    @Test
    public void supportsHttp2Connections() throws Exception {
        HttpClient client = Http2ClientFactory.create();
        this.wm.stubFor(WireMock.get((String)"/thing").willReturn(WireMock.ok((String)"HTTP/2 response")));
        ContentResponse response = client.GET(this.wm.getRuntimeInfo().getHttpsBaseUrl() + "/thing");
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void supportsHttp2PlaintextConnections() throws Exception {
        HttpClient client = Http2ClientFactory.create();
        this.wm.stubFor(WireMock.get((String)"/thing").willReturn(WireMock.ok((String)"HTTP/2 response")));
        ContentResponse response = client.GET(this.wm.url("/thing"));
        MatcherAssert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_2));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void supportsHttp1_1Connections() throws Exception {
        CloseableHttpClient client = HttpClientFactory.createClient();
        this.wm.stubFor(WireMock.get((String)"/thing").willReturn(WireMock.ok((String)"HTTP/1.1 response")));
        HttpGet get = new HttpGet(this.wm.getRuntimeInfo().getHttpsBaseUrl() + "/thing");
        try (CloseableHttpResponse response = client.execute((ClassicHttpRequest)get);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
    }
}

