/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.Http2ClientFactory;
import com.github.tomakehurst.wiremock.HttpsAcceptanceTest;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.ssl.HostVerifyingSSLSocketFactory;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.X509KeyStore;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.ContentResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.RegisterExtension;

public class HttpsBrowserProxyAcceptanceTest {
    private static final String TARGET_KEYSTORE_WITH_CUSTOM_CERT = TestFiles.KEY_STORE_PATH;
    private static final String PROXY_KEYSTORE_WITH_CUSTOM_CA_CERT = TestFiles.KEY_STORE_WITH_CA_PATH;
    private static final String NO_PREEXISTING_KEYSTORE_PATH = HttpsBrowserProxyAcceptanceTest.tempNonExistingPath("wiremock-keystores", "ca-keystore.jks");
    @RegisterExtension
    public static WireMockExtension target = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().httpDisabled(true).keystorePath(TARGET_KEYSTORE_WITH_CUSTOM_CERT).dynamicHttpsPort()).build();
    @RegisterExtension
    public static WireMockExtension proxy = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort().fileSource((FileSource)new SingleRootFileSource(HttpsBrowserProxyAcceptanceTest.setupTempFileRoot())).caKeystorePath(NO_PREEXISTING_KEYSTORE_PATH).enableBrowserProxying(true).trustAllProxyTargets(true)).build();
    private WireMockTestClient testClient;

    @BeforeEach
    public void addAResourceToProxy() {
        this.testClient = new WireMockTestClient(target.getHttpsPort());
    }

    @Test
    public void canProxyHttpsInBrowserProxyMode() throws Exception {
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(target.url("/whatever"), proxy.getPort()).content(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void canProxyHttpsInBrowserHttpsProxyMode() throws Exception {
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
        WireMockResponse response = this.testClient.getViaProxy(target.url("/whatever"), proxy.getHttpsPort(), "https");
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    @Disabled(value="Jetty doesn't yet support proxying via HTTP2")
    public void canProxyHttpsUsingHttp2InBrowserHttpsProxyMode() throws Exception {
        HttpClient httpClient = Http2ClientFactory.create();
        ProxyConfiguration proxyConfig = httpClient.getProxyConfiguration();
        HttpProxy httpProxy = new HttpProxy(new Origin.Address("localhost", proxy.getHttpsPort()), true);
        proxyConfig.getProxies().add(httpProxy);
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
        ContentResponse response = httpClient.GET(target.url("/whatever"));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void canStubHttpsInBrowserProxyMode() throws Exception {
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stubbed")).willReturn(WireMock.aResponse().withBody("Should Not Be Returned")));
        proxy.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stubbed")).willReturn(WireMock.aResponse().withBody("Stubbed Value")));
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/not_stubbed")).willReturn(WireMock.aResponse().withBody("Should be served from target")));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(target.url("/stubbed"), proxy.getPort()).content(), (Matcher)Matchers.is((Object)"Stubbed Value"));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(target.url("/not_stubbed"), proxy.getPort()).content(), (Matcher)Matchers.is((Object)"Should be served from target"));
    }

    @Test
    public void canRecordHttpsInBrowserProxyMode() throws Exception {
        proxy.startRecording(target.baseUrl());
        String recordedEndpoint = target.url("/record_me");
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/record_me")).willReturn(WireMock.aResponse().withBody("Target response")));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(recordedEndpoint, proxy.getPort()).content(), (Matcher)Matchers.is((Object)"Target response"));
        proxy.stopRecording();
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(recordedEndpoint, proxy.getPort()).content(), (Matcher)Matchers.is((Object)"Target response"));
    }

    @Test
    public void rejectsUntrustedTarget() {
        WireMockServer scepticalProxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        try {
            scepticalProxy.start();
            target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
            WireMockResponse response = this.testClient.getViaProxy(target.url("/whatever"), scepticalProxy.port());
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)500));
        }
        finally {
            scepticalProxy.stop();
        }
    }

    @Test
    public void trustsTargetIfTrustStoreContainsItsCertificate() {
        WireMockServer scepticalProxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true).trustStorePath(TestFiles.TRUST_STORE_PATH).trustStorePassword("mytruststorepassword"));
        try {
            scepticalProxy.start();
            target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
            WireMockResponse response = this.testClient.getViaProxy(target.url("/whatever"), scepticalProxy.port());
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Got it"));
        }
        finally {
            scepticalProxy.stop();
        }
    }

    @Test
    public void canTrustSpecificTargetHosts() {
        WireMockServer scepticalProxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true).trustedProxyTargets(new String[]{"localhost"}));
        try {
            scepticalProxy.start();
            target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
            WireMockResponse response = this.testClient.getViaProxy(target.url("/whatever"), scepticalProxy.port());
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Got it"));
        }
        finally {
            scepticalProxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisabledForJreRange(min=JRE.JAVA_17, disabledReason="does not support generating certificates at runtime")
    public void certificatesSignedWithUsersRootCertificate() throws Exception {
        WireMockServer proxyWithCustomCaKeyStore = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true).trustAllProxyTargets(true).caKeystorePath(PROXY_KEYSTORE_WITH_CUSTOM_CA_CERT));
        try {
            proxyWithCustomCaKeyStore.start();
            KeyStore trustStore = HttpsAcceptanceTest.readKeyStore(PROXY_KEYSTORE_WITH_CUSTOM_CA_CERT, "password");
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDnsResolver((DnsResolver)new CustomLocalTldDnsResolver("internal")).setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslSocketFactoryThatTrusts(trustStore)).build();
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setProxy(new HttpHost("localhost", proxyWithCustomCaKeyStore.port())).build();
            httpClient.execute((ClassicHttpRequest)new HttpGet("https://fake1.nowildcards1.internal:" + target.getHttpsPort() + "/whatever"));
            httpClient.execute((ClassicHttpRequest)new HttpGet("https://fake2.nowildcards2.internal:" + target.getHttpsPort() + "/whatever"));
        }
        finally {
            proxyWithCustomCaKeyStore.stop();
        }
    }

    @Test
    @DisabledForJreRange(min=JRE.JAVA_17, disabledReason="does not support generating certificates at runtime")
    public void certificatesSignedWithGeneratedRootCertificate() throws Exception {
        KeyStore trustStore = HttpsAcceptanceTest.readKeyStore(NO_PREEXISTING_KEYSTORE_PATH, "password");
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDnsResolver((DnsResolver)new CustomLocalTldDnsResolver("internal")).setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslSocketFactoryThatTrusts(trustStore)).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setProxy(new HttpHost("localhost", proxy.getPort())).build();
        httpClient.execute((ClassicHttpRequest)new HttpGet("https://fake1.nowildcards1.internal:" + target.getHttpsPort() + "/whatever"));
        httpClient.execute((ClassicHttpRequest)new HttpGet("https://fake2.nowildcards2.internal:" + target.getHttpsPort() + "/whatever"));
    }

    @Test
    public void failsIfCaKeystorePathIsNotAKeystore() throws IOException {
        Assertions.assertThrows(IOException.class, () -> new WireMockServer((Options)WireMockConfiguration.options().enableBrowserProxying(true).caKeystorePath(Files.createTempFile("notakeystore", "jks", new FileAttribute[0]).toString())));
    }

    @Test
    public void failsIfCaKeystoreDoesNotContainACaCertificate() throws Exception {
        Assertions.assertThrows(FatalStartupException.class, () -> ((WireMockServer)new WireMockServer((Options)WireMockConfiguration.options().enableBrowserProxying(true).caKeystorePath(HttpsBrowserProxyAcceptanceTest.emptyKeyStore().toString()))).start());
    }

    @Test
    @DisabledForJreRange(min=JRE.JAVA_17, disabledReason="does not support generating certificates at runtime")
    public void certificateAuthorityCertCanBeDownloaded() throws Exception {
        WireMockTestClient proxyTestClient = new WireMockTestClient(proxy.getPort());
        WireMockResponse certResponse = proxyTestClient.get("/__admin/certs/wiremock-ca.crt", new TestHttpHeader[0]);
        Assertions.assertEquals((int)200, (int)certResponse.statusCode());
        Assertions.assertEquals((Object)"application/x-pem-file", (Object)certResponse.firstHeader("Content-Type"));
        Certificate cert = this.decode(certResponse.content());
        X509KeyStore keyStore = new X509KeyStore(HttpsAcceptanceTest.readKeyStore(NO_PREEXISTING_KEYSTORE_PATH, "password"), "password".toCharArray());
        Assertions.assertEquals((Object)keyStore.getCertificateAuthority().certificateChain()[0], (Object)cert);
    }

    private Certificate decode(String body) throws Exception {
        String base64 = body.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
        byte[] certBytes = Base64.getMimeDecoder().decode(base64);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    private SSLConnectionSocketFactory sslSocketFactoryThatTrusts(KeyStore trustStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(trustStore).build();
        return new SSLConnectionSocketFactory((SSLSocketFactory)new HostVerifyingSSLSocketFactory(sslContext.getSocketFactory()), (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static File setupTempFileRoot() {
        try {
            File root = Files.createTempDirectory("wiremock", new FileAttribute[0]).toFile();
            new File(root, "mappings").mkdirs();
            new File(root, "__files").mkdirs();
            return root;
        }
        catch (IOException e) {
            return (File)Exceptions.throwUnchecked((Throwable)e, File.class);
        }
    }

    private static String tempNonExistingPath(String prefix, String filename) {
        try {
            Path tempDirectory = Files.createTempDirectory(prefix, new FileAttribute[0]);
            return tempDirectory.resolve(filename).toFile().getAbsolutePath();
        }
        catch (IOException e) {
            return (String)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }

    private static Path emptyKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = "password".toCharArray();
        keyStore.load(null, password);
        Path keystoreNoCa = Files.createTempFile("keystore-with-no-ca", "jks", new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(keystoreNoCa.toFile());){
            keyStore.store(fos, password);
        }
        return keystoreNoCa;
    }

    private static class CustomLocalTldDnsResolver
    implements DnsResolver {
        private final String tldToSendToLocalhost;

        public CustomLocalTldDnsResolver(String tldToSendToLocalhost) {
            this.tldToSendToLocalhost = tldToSendToLocalhost;
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            if (host.endsWith("." + this.tldToSendToLocalhost)) {
                return new InetAddress[]{InetAddress.getLocalHost()};
            }
            return new SystemDefaultDnsResolver().resolve(host);
        }

        public String resolveCanonicalHostname(String host) throws UnknownHostException {
            InetAddress[] resolvedAddresses = this.resolve(host);
            if (resolvedAddresses.length > 0) {
                return resolvedAddresses[0].getCanonicalHostName();
            }
            return host;
        }
    }
}

