/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.HttpsAcceptanceTest;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class HttpsBrowserProxyClientAuthAcceptanceTest {
    private static final String NO_PREEXISTING_KEYSTORE_PATH = HttpsBrowserProxyClientAuthAcceptanceTest.tempNonExistingPath("wiremock-keystores", "ca-keystore.jks");
    @RegisterExtension
    public static WireMockExtension target = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort().needClientAuth(true).trustStorePath(TestFiles.TRUST_STORE_PATH).trustStorePassword("mytruststorepassword")).build();
    @RegisterExtension
    public WireMockExtension proxy = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().enableBrowserProxying(true).caKeystorePath(NO_PREEXISTING_KEYSTORE_PATH).trustedProxyTargets(new String[]{"localhost"}).needClientAuth(true).trustStorePath(TestFiles.TRUST_STORE_PATH).trustStorePassword("mytruststorepassword")).build();

    @Test
    public void canDoClientAuthEndToEndWhenProxying() throws Exception {
        target.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.aResponse().withBody("Success")));
        CloseableHttpClient testClient = this.buildHttpClient();
        CloseableHttpResponse response = testClient.execute((ClassicHttpRequest)new HttpGet(target.url("/whatever")));
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.is((Object)"Success"));
    }

    private static String tempNonExistingPath(String prefix, String filename) {
        try {
            Path tempDirectory = Files.createTempDirectory(prefix, new FileAttribute[0]);
            return tempDirectory.resolve(filename).toFile().getAbsolutePath();
        }
        catch (IOException e) {
            return (String)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }

    private CloseableHttpClient buildHttpClient() throws Exception {
        KeyStore trustStore = HttpsAcceptanceTest.readKeyStore(TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(trustStore, "mytruststorepassword".toCharArray()).build();
        HttpHost proxyInfo = new HttpHost("localhost", this.proxy.getPort());
        return HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(sslcontext).setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build()).build()).setProxy(proxyInfo).build();
    }
}

