/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.JvmProxyConfigurer;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class JvmProxyConfigAcceptanceTest {
    WireMockServer wireMockServer;

    @AfterEach
    public void cleanup() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    @Test
    public void configuresHttpProxyingOnlyFromAWireMockServer() throws Exception {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        this.wireMockServer.start();
        JvmProxyConfigurer.configureFor((WireMockServer)this.wireMockServer);
        this.wireMockServer.stubFor(WireMock.get((String)"/stuff").withHost(WireMock.equalTo((String)"example.com")).willReturn(WireMock.ok((String)"Proxied stuff")));
        MatcherAssert.assertThat((Object)this.getContentUsingDefaultJvmHttpClient("http://example.com/stuff"), (Matcher)Matchers.is((Object)"Proxied stuff"));
    }

    @Test
    public void configuresHttpsProxyingOnlyFromAWireMockServer() throws Exception {
        CloseableHttpClient httpClient = HttpClientFactory.createClient();
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        this.wireMockServer.start();
        JvmProxyConfigurer.configureFor((WireMockServer)this.wireMockServer);
        this.wireMockServer.stubFor(WireMock.get((String)"/stuff").withHost(WireMock.equalTo((String)"example.com")).willReturn(WireMock.ok((String)"Proxied stuff")));
        try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)new HttpGet("https://example.com/stuff"));){
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.is((Object)"Proxied stuff"));
        }
    }

    @Test
    public void restoresPreviousSettings() {
        String previousHttpProxyHost = "prevhttpproxyhost";
        String previousHttpProxyPort = "1234";
        String previousHttpsProxyHost = "prevhttpsproxyhost";
        String previousHttpsProxyPort = "4321";
        String previousNonProxyHosts = "blah.com";
        System.setProperty("http.proxyHost", previousHttpProxyHost);
        System.setProperty("http.proxyPort", previousHttpProxyPort);
        System.setProperty("https.proxyHost", previousHttpsProxyHost);
        System.setProperty("https.proxyPort", previousHttpsProxyPort);
        System.setProperty("http.nonProxyHosts", previousNonProxyHosts);
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        this.wireMockServer.start();
        JvmProxyConfigurer.configureFor((WireMockServer)this.wireMockServer);
        MatcherAssert.assertThat((Object)System.getProperty("http.proxyHost"), (Matcher)Matchers.is((Object)"localhost"));
        MatcherAssert.assertThat((Object)System.getProperty("http.proxyPort"), (Matcher)Matchers.is((Object)String.valueOf(this.wireMockServer.port())));
        MatcherAssert.assertThat((Object)System.getProperty("https.proxyHost"), (Matcher)Matchers.is((Object)"localhost"));
        MatcherAssert.assertThat((Object)System.getProperty("https.proxyPort"), (Matcher)Matchers.is((Object)String.valueOf(this.wireMockServer.port())));
        MatcherAssert.assertThat((Object)System.getProperty("http.nonProxyHosts"), (Matcher)Matchers.is((Object)"localhost|127.*|[::1]"));
        JvmProxyConfigurer.restorePrevious();
        MatcherAssert.assertThat((Object)System.getProperty("http.proxyHost"), (Matcher)Matchers.is((Object)previousHttpProxyHost));
        MatcherAssert.assertThat((Object)System.getProperty("http.proxyPort"), (Matcher)Matchers.is((Object)previousHttpProxyPort));
        MatcherAssert.assertThat((Object)System.getProperty("https.proxyHost"), (Matcher)Matchers.is((Object)previousHttpsProxyHost));
        MatcherAssert.assertThat((Object)System.getProperty("https.proxyPort"), (Matcher)Matchers.is((Object)previousHttpsProxyPort));
        MatcherAssert.assertThat((Object)System.getProperty("http.nonProxyHosts"), (Matcher)Matchers.is((Object)previousNonProxyHosts));
    }

    private String getContentUsingDefaultJvmHttpClient(String url) throws Exception {
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
        try (InputStream in = urlConnection.getInputStream();){
            String string = new String(ByteStreams.toByteArray((InputStream)in));
            return string;
        }
    }
}

