/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.testsupport.MultipartBody;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MultipartBodyMatchingAcceptanceTest
extends AcceptanceTestBase {
    CloseableHttpClient httpClient = HttpClientFactory.createClient();

    @Test
    public void acceptsAMultipartRequestContainingATextAndAFilePart() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart").withMultipartRequestBody(WireMock.aMultipart().withName("text").withBody((ContentPattern)WireMock.containing((String)"hello"))).withMultipartRequestBody(WireMock.aMultipart().withName("file").withBody((ContentPattern)WireMock.binaryEqualTo((byte[])"ABCD".getBytes()))).willReturn(WireMock.ok()));
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)(wireMockServer.baseUrl() + "/multipart")).setEntity(MultipartEntityBuilder.create().addTextBody("text", "hello").addBinaryBody("file", "ABCD".getBytes()).build()).build();
        CloseableHttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((String)EntityUtils.toString((HttpEntity)response.getEntity()), (Object)response.getCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void handlesAbsenceOfPartsInAMultipartRequest() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/empty-multipart").withMultipartRequestBody(WireMock.aMultipart().withName("bits").withBody((ContentPattern)WireMock.matching((String)".*"))).willReturn(WireMock.ok()));
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)(wireMockServer.baseUrl() + "/empty-multipart")).setHeader("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW").setEntity((HttpEntity)new StringEntity("", ContentType.MULTIPART_FORM_DATA)).build();
        CloseableHttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void acceptsAMultipartMixedRequestContainingATextAndAFilePart() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart-mixed").withMultipartRequestBody(WireMock.aMultipart().withName("text").withBody((ContentPattern)WireMock.containing((String)"hello"))).withMultipartRequestBody(WireMock.aMultipart().withName("file").withBody((ContentPattern)WireMock.binaryEqualTo((byte[])"ABCD".getBytes()))).willReturn(WireMock.ok()));
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)(wireMockServer.baseUrl() + "/multipart-mixed")).setEntity(MultipartEntityBuilder.create().setMimeSubtype("mixed").addTextBody("text", "hello").addBinaryBody("file", "ABCD".getBytes()).build()).build();
        CloseableHttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((String)EntityUtils.toString((HttpEntity)response.getEntity()), (Object)response.getCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void acceptsAMultipartRelatedRequestContainingATextAndAFilePart() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart-related").withMultipartRequestBody(WireMock.aMultipart().withName("text").withBody((ContentPattern)WireMock.containing((String)"hello"))).withMultipartRequestBody(WireMock.aMultipart().withName("file").withBody((ContentPattern)WireMock.binaryEqualTo((byte[])"ABCD".getBytes()))).willReturn(WireMock.ok()));
        ClassicHttpRequest request = ClassicRequestBuilder.post((String)(wireMockServer.baseUrl() + "/multipart-related")).setEntity(MultipartEntityBuilder.create().setMimeSubtype("related").addTextBody("text", "hello").addBinaryBody("file", "ABCD".getBytes()).build()).build();
        CloseableHttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((String)EntityUtils.toString((HttpEntity)response.getEntity()), (Object)response.getCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void multipartBodiesCanBeMatchedWhenStubsWithOtherBodyMatchTypesArePresent() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart").withMultipartRequestBody(WireMock.aMultipart().withHeader("Content-Disposition", WireMock.containing((String)"wiremocktest"))).willReturn(WireMock.ok()));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/json").withRequestBody((ContentPattern)WireMock.equalToJson((String)"{ \"stuff\": 123 }")).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postWithMultiparts("/multipart", Collections.singletonList(MultipartBody.part("wiremocktest", "Whatever", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    @Timeout(value=2L)
    void handlesLargeMultipartBody() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart").withMultipartRequestBody(WireMock.aMultipart().withHeader("Content-Disposition", WireMock.containing((String)"vlarge"))).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postWithMultiparts("/multipart", Collections.singletonList(MultipartBody.part("vlarge", RandomStringUtils.randomAlphanumeric((int)300000), ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

