/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.testsupport.Assumptions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ResponseDribbleAcceptanceTest {
    private static final int SOCKET_TIMEOUT_MILLISECONDS = 500;
    private static final int DOUBLE_THE_SOCKET_TIMEOUT = 1000;
    private static final byte[] BODY_BYTES = "the long sentence being sent".getBytes();
    public static final double TOLERANCE = 0.333;
    @RegisterExtension
    public WireMockExtension wireMockRule = WireMockExtension.newInstance().configureStaticDsl(true).options((Options)WireMockConfiguration.options().port(0).httpsPort(Integer.valueOf(0))).build();
    private CloseableHttpClient httpClient;

    @BeforeEach
    public void init() throws IOException {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/warmup").willReturn(WireMock.ok()));
        this.httpClient = HttpClientFactory.createClient((int)500);
        this.httpClient.execute((ClassicHttpRequest)new HttpGet(this.wireMockRule.url("/warmup")));
    }

    @Test
    public void requestIsSuccessfulButTakesLongerThanSocketTimeoutWhenDribbleIsEnabled() throws Exception {
        Assumptions.doNotRunOnMacOSXInCI();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delayedDribble").willReturn(WireMock.ok().withBody(BODY_BYTES).withChunkedDribbleDelay(BODY_BYTES.length, 1000)));
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)new HttpGet(this.wireMockRule.url("/delayedDribble")));
        byte[] responseBody = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.is((Object)BODY_BYTES));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(500)));
        MatcherAssert.assertThat((Object)duration, ResponseDribbleAcceptanceTest.isWithinTolerance(1000.0, 0.333));
    }

    @Test
    public void servesAStringBodyInChunks() throws Exception {
        Assumptions.doNotRunOnMacOSXInCI();
        int TOTAL_TIME = 500;
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delayedDribble").willReturn(WireMock.ok().withBody("Send this in many pieces please!!!").withChunkedDribbleDelay(2, 500)));
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)new HttpGet(this.wireMockRule.url("/delayedDribble")));
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        double duration = System.currentTimeMillis() - start;
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.is((Object)"Send this in many pieces please!!!"));
        MatcherAssert.assertThat((Object)duration, ResponseDribbleAcceptanceTest.isWithinTolerance(500.0, 0.333));
    }

    @Test
    public void requestIsSuccessfulAndBelowSocketTimeoutWhenDribbleIsDisabled() throws Exception {
        Assumptions.doNotRunOnMacOSXInCI();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/nonDelayedDribble").willReturn(WireMock.ok().withBody(BODY_BYTES)));
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)new HttpGet(this.wireMockRule.url("/nonDelayedDribble")));
        byte[] responseBody = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)BODY_BYTES, (Matcher)Matchers.is((Object)responseBody));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(500)));
    }

    private static Matcher<Double> isWithinTolerance(double value, double tolerance) {
        double maxDelta = value * tolerance;
        return Matchers.closeTo((double)value, (double)maxDelta);
    }
}

