/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.ServeEventChecks;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.net.InetAddress;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ResponseTemplatingAcceptanceTest {

    @Nested
    class Escaping {
        WireMockTestClient client;
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).templatingEnabled(true).globalTemplating(true).withTemplateEscapingDisabled(false)).build();

        Escaping() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        void escapingIsEnabled() {
            this.wm.stubFor(WireMock.post((String)"/noescape").willReturn(WireMock.ok((String)"{\"test\": \"{{jsonPath request.body '$.a.test'}}\"}")));
            WireMockResponse response = this.client.postJson("/noescape", "{\"a\": {\"test\": \"look at my 'single quotes'\"}}", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{\"test\": \"look at my &#x27;single quotes&#x27;\"}"));
        }
    }

    @Nested
    class NoEscaping {
        WireMockTestClient client;
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).templatingEnabled(true).globalTemplating(true)).build();

        NoEscaping() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        void escapingIsDisabledByDefault() {
            this.wm.stubFor(WireMock.post((String)"/noescape").willReturn(WireMock.ok((String)"{\"test\": \"{{jsonPath request.body '$.a.test'}}\"}")));
            WireMockResponse response = this.client.postJson("/noescape", "{\"a\": {\"test\": \"look at my 'single quotes'\"}}", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{\"test\": \"look at my 'single quotes'\"}"));
        }
    }

    @Nested
    class RestrictedSystemPropertiesAndEnvVars {
        WireMockTestClient client;
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).withPermittedSystemKeys(new String[]{"allowed.*"}).globalTemplating(true)).build();

        RestrictedSystemPropertiesAndEnvVars() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        public void appliesResponseTemplateWithHostname() throws Exception {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBody("{{hostname}}")));
            String expectedHostname = InetAddress.getLocalHost().getHostName();
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)expectedHostname));
        }

        @Test
        public void rendersPermittedSystemProperty() {
            System.setProperty("allowed.thing", "123");
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBody("{{systemValue type='PROPERTY' key='allowed.thing'}}")));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"123"));
        }

        @Test
        public void refusesToRenderForbiddenSystemProperty() {
            System.setProperty("forbidden.thing", "456");
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBody("{{systemValue type='PROPERTY' key='forbidden.thing'}}")));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"[ERROR: Access to forbidden.thing is denied]"));
        }

        @Test
        public void appliesResponseTemplateShouldNotEmptyWithExistingSystemValue() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBody("{{systemValue type='ENVIRONMENT' key='PATH'}}")));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.notNullValue());
        }
    }

    @Nested
    class Global {
        WireMockTestClient client;
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).templatingEnabled(true).globalTemplating(true)).build();

        Global() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        public void appliesResponseTemplate() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBody("{{request.path.[0]}}")));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"templated"));
        }

        @Test
        public void appliesToResponseBodyFromFile() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBodyFile("templated-example-1.txt")));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"templated"));
        }

        @Test
        public void copesWithBase64BodiesWithoutTemplateElements() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/documents/document/.+")).willReturn(WireMock.ok().withBase64Body("JVBERi0xLjEKJcKlwrHDqwoKMSAwIG9iagogIDw8IC9UeXBlIC9DYXRhbG9nCiAgICAgL1BhZ2VzIDIgMCBSCiAgPj4KZW5kb2JqCgoyIDAgb2JqCiAgPDwgL1R5cGUgL1BhZ2VzCiAgICAgL0tpZHMgWzMgMCBSXQogICAgIC9Db3VudCAxCiAgICAgL01lZGlhQm94IFswIDAgMzAwIDE0NF0KICA+PgplbmRvYmoKCjMgMCBvYmoKICA8PCAgL1R5cGUgL1BhZ2UKICAgICAgL1BhcmVudCAyIDAgUgogICAgICAvUmVzb3VyY2VzCiAgICAgICA8PCAvRm9udAogICAgICAgICAgIDw8IC9GMQogICAgICAgICAgICAgICA8PCAvVHlwZSAvRm9udAogICAgICAgICAgICAgICAgICAvU3VidHlwZSAvVHlwZTEKICAgICAgICAgICAgICAgICAgL0Jhc2VGb250IC9UaW1lcy1Sb21hbgogICAgICAgICAgICAgICA+PgogICAgICAgICAgID4+CiAgICAgICA+PgogICAgICAvQ29udGVudHMgNCAwIFIKICA+PgplbmRvYmoKCjQgMCBvYmoKICA8PCAvTGVuZ3RoIDU1ID4+CnN0cmVhbQogIEJUCiAgICAvRjEgMTggVGYKICAgIDAgMCBUZAogICAgKEhlbGxvIFdvcmxkKSBUagogIEVUCmVuZHN0cmVhbQplbmRvYmoKCnhyZWYKMCA1CjAwMDAwMDAwMDAgNjU1MzUgZiAKMDAwMDAwMDAxOCAwMDAwMCBuIAowMDAwMDAwMDc3IDAwMDAwIG4gCjAwMDAwMDAxNzggMDAwMDAgbiAKMDAwMDAwMDQ1NyAwMDAwMCBuIAp0cmFpbGVyCiAgPDwgIC9Sb290IDEgMCBSCiAgICAgIC9TaXplIDUKICA+PgpzdGFydHhyZWYKNTY1CiUlRU9GCg==")));
            WireMockResponse response = this.client.get("/documents/document/123", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        }

        @Test
        public void supportsSelectionResponseBodyTemplateViaTemplate() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/templated/.*")).willReturn(WireMock.aResponse().withBodyFile("templated-example-{{request.path.1}}.txt")));
            MatcherAssert.assertThat((Object)this.client.get("/templated/2", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"templated"));
            MatcherAssert.assertThat((Object)this.client.get("/templated/3", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"3"));
        }

        @Test
        public void cacheIsClearedWhenStubEdited() {
            String url = "/templated/one/two";
            UUID id = UUID.randomUUID();
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)url)).withId(id).willReturn(WireMock.aResponse().withHeader("X-Value", new String[]{"{{request.path.1}}"}).withBody("{{request.path.1}}")));
            WireMockResponse response = this.client.get(url, new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"one"));
            MatcherAssert.assertThat((Object)response.firstHeader("X-Value"), (Matcher)Matchers.is((Object)"one"));
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)url)).withId(id).willReturn(WireMock.aResponse().withHeader("X-Value", new String[]{"{{request.path.2}}"}).withBody("{{request.path.2}}")));
            response = this.client.get(url, new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"two"));
            MatcherAssert.assertThat((Object)response.firstHeader("X-Value"), (Matcher)Matchers.is((Object)"two"));
        }

        @Test
        public void supportsDisablingTemplatingOfBodyFilesPerStub() {
            UUID id = UUID.randomUUID();
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).withId(id).willReturn(WireMock.aResponse().withBodyFile("templated-example-1.txt")));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"templated"));
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).withId(id).willReturn(WireMock.aResponse().withBodyFile("templated-example-1.txt").withTransformerParameter("disableBodyFileTemplating", (Object)true)));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{{request.path.[0]}}"));
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/templated/.*")).withId(id).willReturn(WireMock.aResponse().withBodyFile("templated-example-{{request.path.1}}.txt").withTransformerParameter("disableBodyFileTemplating", (Object)true)));
            MatcherAssert.assertThat((Object)this.client.get("/templated/1", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{{request.path.[0]}}"));
        }

        @Test
        public void supportsJsonBodiesWithTemplating() {
            String stubJson = "{\n  \"request\": {\n    \"method\": \"POST\",\n    \"url\" : \"/json-body-templating\"\n  },\n  \"response\": {\n    \"status\": 200,\n    \"jsonBody\": {\n      \"modified\": \"{{jsonPath request.body '$.arrayprop.length()'}}\"\n    },\n    \"headers\": {\n      \"Content-Type\": \"application/json\"\n    }\n  }\n}";
            this.client.postJson("/__admin/mappings", stubJson, new TestHttpHeader[0]);
            WireMockResponse response = this.client.postJson("/json-body-templating", "{ \"arrayprop\": [1,2,3] }", new TestHttpHeader[0]);
            MatcherAssert.assertThat((String)response.content(), (Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalToJson("{ \"modified\": \"3\" }"));
        }

        @Test
        public void jsonBodyTemplatesCanSpecifyRequestAttributes() {
            String stubJson = "{\n  \"request\": {\n    \"method\": \"GET\",\n    \"urlPath\": \"/jsonBody/template\"\n  },\n  \"response\": {\n    \"jsonBody\": {\n      \"Key\": \"Hello world {{request.query.qp}}!\"\n    },\n    \"status\": 200,\n    \"transformers\": [\n      \"response-template\"\n    ]\n  }\n}";
            this.client.postJson("/__admin/mappings", stubJson, new TestHttpHeader[0]);
            WireMockResponse response = this.client.get("/jsonBody/template?qp=2", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{\"Key\":\"Hello world 2!\"}"));
        }

        @Test
        public void canLookupSquareBracketedQueryParameters() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/squares")).willReturn(WireMock.ok((String)"ID: {{lookup request.query 'filter[id]'}}")));
            MatcherAssert.assertThat((Object)this.client.get("/squares?filter[id]=321", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"ID: 321"));
            MatcherAssert.assertThat((Object)this.client.get("/squares?filter%5Bid%5D=321", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"ID: 321"));
        }

        @Test
        void canReadPathParametersFromModelWhenStubUsesPathTemplate() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/v1/contacts/{contactId}/addresses/{addressId}")).willReturn(WireMock.ok((String)"contactId: {{request.path.contactId}}, addressId: {{request.path.addressId}}")));
            String content = this.client.get("/v1/contacts/12345/addresses/67890", new TestHttpHeader[0]).content();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)"contactId: 12345, addressId: 67890"));
        }

        @Test
        void canReadPathSegmentsByIndexWhenStubUsesPathTemplate() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/v1/contacts/{contactId}/addresses/{addressId}")).willReturn(WireMock.ok((String)"1: {{request.path.1}}, 2: {{request.path.2}}")));
            String content = this.client.get("/v1/contacts/12345/addresses/67890", new TestHttpHeader[0]).content();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)"1: contacts, 2: 12345"));
        }

        @Test
        void canReadNumericPathVariableValuesWhenUsingPathTemnplate() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/v1/first/{0}/second/{1}")).willReturn(WireMock.ok((String)"1: {{request.path.0}}, 2: {{request.path.1}}")));
            String content = this.client.get("/v1/first/first1/second/second2", new TestHttpHeader[0]).content();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)"1: first1, 2: second2"));
        }

        @Test
        void canLoopOverPathSegmentsWhenUsingPathTemplate() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/v1/first/{0}/second/{1}")).willReturn(WireMock.ok((String)"{{#each request.path as |segment|}}{{segment}} {{/each}}")));
            String content = this.client.get("/v1/first/first1/second/second2", new TestHttpHeader[0]).content();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)" v1 first first1 second second2 "));
        }

        @Test
        void exceptionThrownWhileRenderingIsReportedViaSubEvent() {
            this.wm.stubFor(WireMock.get((String)"/bad").willReturn(WireMock.ok((String)"{{math '1' '/' 0}}")));
            WireMockResponse response = this.client.get("/bad", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)500));
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"1:2: java.lang.ArithmeticException: / by zero"));
            ServeEventChecks.assertMessageSubEventPresent((Admin)this.wm, "ERROR", "1:2: java.lang.ArithmeticException: / by zero");
        }
    }

    @Nested
    class Local {
        WireMockTestClient client;
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().templatingEnabled(true).globalTemplating(false)).build();

        Local() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wm.getPort());
        }

        @Test
        public void appliesResponseTemplateWhenAddedToStubMapping() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/templated")).willReturn(WireMock.aResponse().withBody("{{request.path.[0]}}").withTransformers(new String[]{"response-template"})));
            MatcherAssert.assertThat((Object)this.client.get("/templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"templated"));
        }

        @Test
        public void doesNotIncludeQueryParametersInPathVariableValue() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/{template_param}")).willReturn(WireMock.aResponse().withBody("{ \"key\": \"{{{ request.path.template_param }}}\" }").withTransformers(new String[]{"response-template"})));
            String content = this.client.get("/foo?bar=1", new TestHttpHeader[0]).content();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)"{ \"key\": \"foo\" }"));
        }

        @Test
        public void doesNotApplyResponseTemplateWhenNotAddedToStubMapping() {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/not-templated")).willReturn(WireMock.aResponse().withBody("{{request.path.[0]}}")));
            MatcherAssert.assertThat((Object)this.client.get("/not-templated", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{{request.path.[0]}}"));
        }
    }
}

