/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ResponseTransformerAcceptanceTest {
    WireMockServer wm;
    WireMockTestClient client;

    @Test
    public void transformsStubResponse() {
        this.startWithExtensions(StubResponseTransformer.class);
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/response-transform")).willReturn(WireMock.aResponse().withBody("Original body")));
        MatcherAssert.assertThat((Object)this.client.get("/response-transform", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Modified body"));
    }

    @Test
    public void acceptsTransformerParameters() {
        this.startWithExtensions(StubResponseTransformerWithParams.class);
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/response-transform-with-params")).willReturn(WireMock.aResponse().withTransformerParameter("name", (Object)"John").withTransformerParameter("number", (Object)66).withTransformerParameter("flag", (Object)true).withBody("Original body")));
        MatcherAssert.assertThat((Object)this.client.get("/response-transform-with-params", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"John, 66, true"));
    }

    @Test
    public void globalTransformAppliedWithLocalParameters() {
        this.startWithExtensions(GlobalResponseTransformer.class);
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/global-response-transform")).willReturn(WireMock.aResponse()));
        MatcherAssert.assertThat((Object)this.client.get("/global-response-transform", new TestHttpHeader[0]).firstHeader("X-Extra"), (Matcher)Matchers.is((Object)"extra val"));
    }

    @Test
    public void filesRootIsCorrectlyPassedToTransformer() {
        this.startWithExtensions(FilesUsingResponseTransformer.class);
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/response-transform-with-files")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.get("/response-transform-with-files", new TestHttpHeader[0]).content(), (Matcher)Matchers.endsWith((String)"plain-example.txt"));
    }

    private void startWithExtensions(Class<? extends Extension> extensionClasses) {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Class[]{extensionClasses}));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    public static class FilesUsingResponseTransformer
    extends ResponseTransformer {
        public Response transform(Request request, Response response, FileSource files, Parameters parameters) {
            return Response.Builder.like((Response)response).but().body(files.getTextFileNamed("plain-example.txt").getPath()).build();
        }

        public String getName() {
            return "files-using-response-transformer";
        }

        public boolean applyGlobally() {
            return true;
        }
    }

    public static class GlobalResponseTransformer
    extends ResponseTransformer {
        public Response transform(Request request, Response response, FileSource files, Parameters parameters) {
            return Response.Builder.like((Response)response).but().headers(response.getHeaders().plus(new HttpHeader[]{HttpHeader.httpHeader((String)"X-Extra", (String[])new String[]{"extra val"})})).build();
        }

        public String getName() {
            return "global-response-transformer";
        }

        public boolean applyGlobally() {
            return true;
        }
    }

    public static class StubResponseTransformerWithParams
    extends ResponseTransformer {
        public Response transform(Request request, Response response, FileSource files, Parameters parameters) {
            return Response.Builder.like((Response)response).but().body(parameters.getString("name") + ", " + parameters.getInt("number") + ", " + parameters.getBoolean("flag")).build();
        }

        public boolean applyGlobally() {
            return true;
        }

        public String getName() {
            return "stub-transformer-with-params";
        }
    }

    public static class StubResponseTransformer
    extends ResponseTransformer {
        public Response transform(Request request, Response response, FileSource files, Parameters parameters) {
            return Response.Builder.like((Response)response).but().body("Modified body").build();
        }

        public boolean applyGlobally() {
            return true;
        }

        public String getName() {
            return "stub-transformer";
        }
    }
}

