/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ClientError;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScenarioAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void createMappingsInScenarioAndChangeResponseWithStateChange() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).willReturn(WireMock.aResponse().withBody("Initial")).inScenario("SomeResourceUpdate").whenScenarioStateIs("Started"));
        WireMock.givenThat((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).willReturn(WireMock.aResponse().withStatus(200)).inScenario("SomeResourceUpdate").willSetStateTo("BodyModified").whenScenarioStateIs("Started"));
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).willReturn(WireMock.aResponse().withBody("Modified")).inScenario("SomeResourceUpdate").whenScenarioStateIs("BodyModified"));
        MatcherAssert.assertThat((Object)testClient.get("/some/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Initial"));
        testClient.put("/some/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)testClient.get("/some/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Modified"));
    }

    @Test
    public void mappingInScenarioIndependentOfCurrentState() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/state/independent/resource")).willReturn(WireMock.aResponse().withBody("Some content")).inScenario("StateIndependent"));
        WireMock.givenThat((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/state/modifying/resource")).willReturn(WireMock.aResponse().withStatus(200)).inScenario("StateIndependent").willSetStateTo("BodyModified"));
        WireMockResponse response = testClient.get("/state/independent/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Some content"));
        testClient.put("/state/modifying/resource", new TestHttpHeader[0]);
        response = testClient.get("/state/independent/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Some content"));
    }

    @Test
    public void resetAllScenariosState() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stateful/resource")).willReturn(WireMock.aResponse().withBody("Expected content")).inScenario("ResetScenario").whenScenarioStateIs("Started"));
        WireMock.givenThat((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/stateful/resource")).willReturn(WireMock.aResponse().withStatus(200)).inScenario("ResetScenario").willSetStateTo("Changed"));
        testClient.put("/stateful/resource", new TestHttpHeader[0]);
        WireMock.resetAllScenarios();
        MatcherAssert.assertThat((Object)testClient.get("/stateful/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Expected content"));
    }

    @Test
    public void settingScenarioNameToNullCausesException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).willReturn(WireMock.aResponse()).inScenario(null));
    }

    @Test
    public void canGetAllScenarios() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/1").inScenario("scenario_one").whenScenarioStateIs("Started").willSetStateTo("state_2").willReturn(WireMock.ok((String)"1:1")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/2").inScenario("scenario_two").whenScenarioStateIs("Started").willReturn(WireMock.ok((String)"2:1")));
        testClient.get("/scenarios/1", new TestHttpHeader[0]);
        List scenarios = WireMock.getAllScenarios();
        Scenario scenario1 = (Scenario)scenarios.stream().filter(Scenario.withName((String)"scenario_one")).findAny().orElseThrow();
        MatcherAssert.assertThat((Object)scenario1.getPossibleStates(), (Matcher)Matchers.hasItems((Object[])new String[]{"Started", "state_2"}));
        MatcherAssert.assertThat((Object)scenario1.getState(), (Matcher)Matchers.is((Object)"state_2"));
        Scenario scenario2 = (Scenario)scenarios.stream().filter(Scenario.withName((String)"scenario_two")).findAny().orElseThrow();
        MatcherAssert.assertThat((Object)scenario2.getState(), (Matcher)Matchers.is((Object)"Started"));
    }

    @Test
    public void scenarioIsRemovedWhenLastMappingReferringToItIsRemoved() {
        String NAME = "remove_this_scenario";
        StubMapping stub1 = WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/22").inScenario("remove_this_scenario").whenScenarioStateIs("Started").willSetStateTo("state_2").willReturn(WireMock.ok((String)"1")));
        StubMapping stub2 = WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/22").inScenario("remove_this_scenario").whenScenarioStateIs("state_2").willSetStateTo("state_2").willReturn(WireMock.ok((String)"2")));
        StubMapping stub3 = WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/22").inScenario("remove_this_scenario").whenScenarioStateIs("state_2").willSetStateTo("state_3").willReturn(WireMock.ok((String)"3")));
        MatcherAssert.assertThat((Object)WireMock.getAllScenarios().size(), (Matcher)Matchers.is((Object)1));
        WireMock.removeStub((StubMapping)stub1);
        WireMock.removeStub((StubMapping)stub2);
        WireMock.removeStub((StubMapping)stub3);
        MatcherAssert.assertThat((Object)WireMock.getAllScenarios().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void scenarioIsRemovedWhenLastMappingReferringToHasItsScenarioNameChanged() {
        UUID ID1 = UUID.randomUUID();
        UUID ID2 = UUID.randomUUID();
        String OLD_NAME = "old_scenario";
        String NEW_NAME = "new_scenario";
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/33").withId(ID1).inScenario("old_scenario").whenScenarioStateIs("Started").willSetStateTo("state_2").willReturn(WireMock.ok((String)"1")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/scenarios/33").withId(ID2).inScenario("old_scenario").whenScenarioStateIs("state_2").willSetStateTo("state_2").willReturn(WireMock.ok((String)"2")));
        MatcherAssert.assertThat((Object)WireMock.getAllScenarios().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Scenario)WireMock.getAllScenarios().get(0)).getId(), (Matcher)Matchers.is((Object)"old_scenario"));
        WireMock.editStub((MappingBuilder)WireMock.get((String)"/scenarios/33").withId(ID1).inScenario("new_scenario").whenScenarioStateIs("Started").willSetStateTo("state_2").willReturn(WireMock.ok((String)"1")));
        WireMock.editStub((MappingBuilder)WireMock.get((String)"/scenarios/33").withId(ID2).inScenario("new_scenario").whenScenarioStateIs("state_2").willSetStateTo("state_2").willReturn(WireMock.ok((String)"2")));
        MatcherAssert.assertThat((Object)WireMock.getAllScenarios().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Scenario)WireMock.getAllScenarios().get(0)).getId(), (Matcher)Matchers.is((Object)"new_scenario"));
    }

    @Test
    public void returnsEmptyMapOnGetAllScenariosWhenThereAreNone() {
        MatcherAssert.assertThat((Object)WireMock.getAllScenarios().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void scenarioBuilderMethodsDoNotNeedToBeContiguous() {
        WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).inScenario("Scenario").willReturn(WireMock.aResponse()).whenScenarioStateIs("Prior State").atPriority(Integer.valueOf(1)).willSetStateTo("Next State");
    }

    @Test
    public void resetsASingleScenarioByName() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("reset-me").whenScenarioStateIs("Started").willSetStateTo("2").willReturn(WireMock.ok((String)"started")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("reset-me").whenScenarioStateIs("2").willReturn(WireMock.ok((String)"2")));
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"started"));
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"2"));
        WireMock.resetScenario((String)"reset-me");
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"started"));
    }

    @Test
    public void setsASingleScenarioStateByName() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("set-me").whenScenarioStateIs("Started").willSetStateTo("2").willReturn(WireMock.ok((String)"started")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("set-me").whenScenarioStateIs("2").willSetStateTo("3").willReturn(WireMock.ok((String)"2")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("set-me").whenScenarioStateIs("3").willReturn(WireMock.ok((String)"3")));
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"started"));
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"3"));
        WireMock.setScenarioState((String)"set-me", (String)"2");
        MatcherAssert.assertThat((Object)testClient.get("/one", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    void throwsClientErrorWhenAttemptingToResetNonExistentScenario() {
        Assertions.assertThrows(ClientError.class, () -> WireMock.resetScenario((String)"non-exist"));
    }

    @Test
    void throwsClientErrorWhenAttemptingToSetToNonExistentState() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("set-me").whenScenarioStateIs("Started").willSetStateTo("2").willReturn(WireMock.ok((String)"started")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("set-me").whenScenarioStateIs("2").willSetStateTo("3").willReturn(WireMock.ok((String)"2")));
        Assertions.assertThrows(ClientError.class, () -> WireMock.setScenarioState((String)"set-me", (String)"non-exist"));
    }
}

