/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Dates;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.MappingJsonSamples;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.Test;

public class ServeEventLogAcceptanceTest
extends AcceptanceTestBase {
    static Stubbing dsl = wireMockServer;

    @Test
    public void returnsRecordedRequestsMatchingOnMethodAndExactUrl() throws Exception {
        testClient.get("/return/this", new TestHttpHeader[0]);
        testClient.get("/but/not/this", new TestHttpHeader[0]);
        testClient.get("/return/this", new TestHttpHeader[0]);
        testClient.get("/return/this", new TestHttpHeader[0]);
        testClient.get("/but/not/this", new TestHttpHeader[0]);
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/return/this")));
        MatcherAssert.assertThat((Object)requests.size(), (Matcher)Matchers.is((Object)3));
        LoggedRequest firstRequest = (LoggedRequest)requests.get(0);
        MatcherAssert.assertThat((Object)firstRequest.getUrl(), (Matcher)Matchers.is((Object)"/return/this"));
        MatcherAssert.assertThat((Object)firstRequest.getMethod(), (Matcher)Matchers.is((Object)RequestMethod.GET));
        MatcherAssert.assertThat((Object)firstRequest.getLoggedDate(), WireMatchers.isToday());
        MatcherAssert.assertThat((Object)ServeEventLogAcceptanceTest.parse(firstRequest.getLoggedDateString()), WireMatchers.isToday());
    }

    @Test
    public void returnsRecordedRequestsMatchingOnMethodAndUrlRegex() {
        testClient.put("/should/return/this/request", new TestHttpHeader[0]);
        testClient.get("/donot/return/this/request", new TestHttpHeader[0]);
        testClient.put("/also/return/this", new TestHttpHeader[0]);
        testClient.put("/not/this", new TestHttpHeader[0]);
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlMatching((String)".*return/this.*")));
        MatcherAssert.assertThat((Object)requests.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.withUrl("/should/return/this/request"), this.withUrl("/also/return/this")}));
    }

    @Test
    public void returnsNoResultsAfterReset() {
        testClient.get("/blah", new TestHttpHeader[0]);
        testClient.get("/blah", new TestHttpHeader[0]);
        testClient.get("/blah", new TestHttpHeader[0]);
        WireMock.reset();
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/blah")));
        MatcherAssert.assertThat((Object)requests.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void returnsNoResultsAfterRequestsReset() {
        testClient.get("/blah", new TestHttpHeader[0]);
        testClient.get("/blah", new TestHttpHeader[0]);
        testClient.get("/blah", new TestHttpHeader[0]);
        WireMock.resetAllRequests();
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/blah")));
        MatcherAssert.assertThat((Object)requests.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void resultsAreInOrderRequestsWereReceived() {
        testClient.get("/use/1", new TestHttpHeader[0]);
        testClient.get("/ignore/1", new TestHttpHeader[0]);
        testClient.get("/ignore/2", new TestHttpHeader[0]);
        testClient.get("/use/2", new TestHttpHeader[0]);
        testClient.get("/use/3", new TestHttpHeader[0]);
        testClient.get("/ignore/3", new TestHttpHeader[0]);
        testClient.get("/use/4", new TestHttpHeader[0]);
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlMatching((String)"/use/.*")));
        MatcherAssert.assertThat((Object)requests, WireMatchers.hasExactly(this.withUrl("/use/1"), this.withUrl("/use/2"), this.withUrl("/use/3"), this.withUrl("/use/4")));
    }

    @Test
    public void requestBodyEncodingRemainsUtf8() {
        byte[] body = new byte[]{-38, -100};
        testClient.post("/encoding", (HttpEntity)new ByteArrayEntity(body, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)), new TestHttpHeader[0]);
        List requests = WireMock.findAll((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/encoding")));
        LoggedRequest request = (LoggedRequest)requests.get(0);
        MatcherAssert.assertThat((Object)request.getBodyAsString(), (Matcher)Matchers.is((Object)"\u069c"));
    }

    @Test
    public void getsAllServeEvents() {
        dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/two")).willReturn(WireMock.aResponse().withStatus(200).withBody("Exactly 2")));
        testClient.get("/one", new TestHttpHeader[0]);
        testClient.get("/two", new TestHttpHeader[0]);
        testClient.get("/three", new TestHttpHeader[0]);
        List serveEvents = WireMock.getAllServeEvents();
        ServeEvent three = (ServeEvent)serveEvents.get(0);
        MatcherAssert.assertThat((Object)three.isNoExactMatch(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)three.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/three"));
        ServeEvent two = (ServeEvent)serveEvents.get(1);
        MatcherAssert.assertThat((Object)two.isNoExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)two.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/two"));
        MatcherAssert.assertThat((Object)two.getResponse().getBody(), (Matcher)Matchers.is((Object)"Exactly 2".getBytes()));
        MatcherAssert.assertThat((Object)two.getResponse().getBodyAsString(), (Matcher)Matchers.is((Object)"Exactly 2"));
        MatcherAssert.assertThat((Object)two.getResponse().getBodyAsBase64(), (Matcher)Matchers.is((Object)Encoding.encodeBase64((byte[])"Exactly 2".getBytes())));
        MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(2)).isNoExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getAllServeEventsPreservesBinaryBody() {
        dsl.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withBody(MappingJsonSamples.BINARY_COMPRESSED_CONTENT)));
        testClient.get("/", new TestHttpHeader[0]);
        List serveEvents = WireMock.getAllServeEvents();
        ServeEvent serveEvent = (ServeEvent)serveEvents.get(0);
        MatcherAssert.assertThat((Object)serveEvent.getResponse().getBody(), (Matcher)Matchers.is((Object)MappingJsonSamples.BINARY_COMPRESSED_CONTENT));
    }

    @Test
    public void getsAllServeEventsThatWereUnmatched() {
        dsl.stubFor(WireMock.get((String)"/match").willReturn(WireMock.ok()));
        testClient.get("/match", new TestHttpHeader[0]);
        testClient.get("/no-match", new TestHttpHeader[0]);
        testClient.get("/just-wrong", new TestHttpHeader[0]);
        testClient.get("/match", new TestHttpHeader[0]);
        List serveEvents = WireMock.getAllServeEvents((ServeEventQuery)ServeEventQuery.ALL_UNMATCHED);
        MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/just-wrong"));
        MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/no-match"));
    }

    @Test
    public void getsAllServeEventsThatMatchedStubId() {
        wm.stubFor(WireMock.get((String)"/one").willReturn(WireMock.ok()));
        StubMapping stub2 = wm.stubFor(WireMock.get((String)"/two").willReturn(WireMock.ok()));
        testClient.get("/two", new TestHttpHeader[0]);
        testClient.get("/one", new TestHttpHeader[0]);
        testClient.get("/one", new TestHttpHeader[0]);
        testClient.get("/two", new TestHttpHeader[0]);
        List serveEvents = WireMock.getAllServeEvents((ServeEventQuery)ServeEventQuery.forStubMapping((StubMapping)stub2));
        MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/two"));
        MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/two"));
    }

    private Matcher<LoggedRequest> withUrl(final String url) {
        return new TypeSafeMatcher<LoggedRequest>(){

            public boolean matchesSafely(LoggedRequest loggedRequest) {
                return loggedRequest.getUrl().equals(url);
            }

            public void describeTo(Description description) {
                description.appendText("A logged request with url: " + url);
            }
        };
    }

    private static Date parse(String dateString) throws ParseException {
        return Dates.parse((String)dateString);
    }
}

