/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StubMappingPersistenceAcceptanceTest {
    Path rootDir;
    Path mappingsDir;
    WireMockServer wireMockServer;
    WireMockTestClient testClient;
    Stubbing wm;

    @BeforeEach
    public void init() throws Exception {
        this.rootDir = Files.createTempDirectory("temp-filesource", new FileAttribute[0]);
        this.mappingsDir = this.rootDir.resolve("mappings");
        SingleRootFileSource fileSource = new SingleRootFileSource(this.rootDir.toAbsolutePath().toString());
        fileSource.createIfNecessary();
        FileSource filesFileSource = fileSource.child("__files");
        filesFileSource.createIfNecessary();
        FileSource mappingsFileSource = fileSource.child("mappings");
        mappingsFileSource.createIfNecessary();
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().fileSource((FileSource)fileSource).dynamicPort());
        this.wireMockServer.start();
        this.testClient = new WireMockTestClient(this.wireMockServer.port());
        WireMock.configureFor((int)this.wireMockServer.port());
        this.wm = this.wireMockServer;
    }

    @Test
    public void savesAllInMemoryStubMappings() {
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/1")).willReturn(WireMock.aResponse().withBody("one")));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/2")).willReturn(WireMock.aResponse().withBody("two")));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/3")).willReturn(WireMock.aResponse().withBody("three")));
        this.wireMockServer.saveMappings();
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("one"));
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("two"));
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("three"));
    }

    @Test
    public void savesEditedStubToTheFileItOriginatedFrom() throws Exception {
        UUID stubId = UUID.randomUUID();
        this.writeMappingFile("mapping-to-edit.json", WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/edit")).withId(stubId).willReturn(WireMock.aResponse().withBody("initial")));
        this.wireMockServer.resetToDefaultMappings();
        MatcherAssert.assertThat((Object)((StubMapping)this.wm.getStubMappings().get(0)).getId(), (Matcher)Matchers.is((Object)stubId));
        MatcherAssert.assertThat((Object)((StubMapping)this.wm.getStubMappings().get(0)).getResponse().getBody(), (Matcher)Matchers.is((Object)"initial"));
        this.wm.editStub(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/edit")).withId(stubId).willReturn(WireMock.aResponse().withBody("modified")));
        this.wireMockServer.saveMappings();
        this.assertMappingsDirContainsOneFile();
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("modified"));
    }

    @Test
    public void savesSingleStubOnCreationIfFlaggedPersistent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/save-immediately")).persistent());
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("/save-immediately"));
    }

    @Test
    public void doesNotSaveSingleStubOnCreationIfNotFlaggedPersistent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/save-immediately")));
        this.assertMappingsDirIsEmpty();
    }

    @Test
    public void savesSingleStubOnEditIfFlaggedPersistent() {
        UUID stubId = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/save-immediately")).persistent().withId(stubId).willReturn(WireMock.aResponse().withBody("initial")));
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("/save-immediately", "initial"));
        WireMock.editStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/save-immediately")).persistent().withId(stubId).willReturn(WireMock.aResponse().withBody("modified")));
        this.assertMappingsDirContainsOneFile();
        MatcherAssert.assertThat((Object)this.mappingsDir, WireMatchers.hasFileContaining("/save-immediately", "modified"));
    }

    @Test
    public void doesNotSaveSingleStubOnEditIfNotFlaggedPersistent() {
        UUID stubId = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/no-save")).withId(stubId).willReturn(WireMock.aResponse().withBody("initial")));
        WireMock.editStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/no-save")).withId(stubId).willReturn(WireMock.aResponse().withBody("modified")));
        this.assertMappingsDirIsEmpty();
    }

    @Test
    public void deletesPersistentStubMappingIfFlaggedPersistent() {
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/to-delete")).persistent());
        this.assertMappingsDirContainsOneFile();
        WireMock.removeStub((StubMapping)stubMapping);
        this.assertMappingsDirIsEmpty();
    }

    @Test
    public void doesNotDeleteStubMappingFromDiskIfNotFlaggedPersistent() throws Exception {
        UUID id = UUID.randomUUID();
        StubMapping stubMapping = WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/do-not-delete")).withId(id).build();
        Files.write(this.mappingsDir.resolve("do-not-delete.json"), Json.write((Object)stubMapping).getBytes(), new OpenOption[0]);
        WireMock.resetToDefault();
        MatcherAssert.assertThat((Object)WireMock.getSingleStubMapping((UUID)id).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/do-not-delete"));
        this.assertMappingsDirContainsOneFile();
        WireMock.removeStub((StubMapping)stubMapping);
        this.assertMappingsDirContainsOneFile();
    }

    @Test
    public void deletesAllPersistentStubMappingsOnReset() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/to-delete/1")).persistent());
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/to-delete/2")).persistent());
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/to-delete/3")).persistent());
        this.assertMappingsDirSize(3);
        WireMock.removeAllMappings();
        this.assertMappingsDirIsEmpty();
    }

    @Test
    public void deletesNestedPersistentStubMapping() throws IOException {
        UUID stubId = UUID.randomUUID();
        Path subDirectoryUnderMappingsRoot = Files.createDirectory(this.mappingsDir.resolve("sub-dir"), new FileAttribute[0]);
        Path mappingFilePath = subDirectoryUnderMappingsRoot.resolve("mapping-to-delete.json");
        this.writeMappingFile(mappingFilePath.toString(), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/to-delete")).withId(stubId).persistent());
        this.wireMockServer.resetToDefaultMappings();
        MatcherAssert.assertThat((Object)mappingFilePath.toFile().exists(), (Matcher)Matchers.is((Object)true));
        StubMapping stubMapping = (StubMapping)this.wm.getStubMappings().get(0);
        MatcherAssert.assertThat((Object)stubMapping.getId(), (Matcher)Matchers.is((Object)stubId));
        WireMock.removeStub((StubMapping)stubMapping);
        MatcherAssert.assertThat((Object)mappingFilePath.toFile().exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void preservesPersistentFlagFalseValue() {
        UUID id = this.wm.stubFor(WireMock.get((String)"/no-persist").persistent(false)).getId();
        StubMapping retrivedStub = this.wm.getSingleStubMapping(id);
        MatcherAssert.assertThat((Object)retrivedStub.isPersistent(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)retrivedStub.isPersistent(), (Matcher)Matchers.is((Object)false));
    }

    private void writeMappingFile(String name, MappingBuilder stubBuilder) throws IOException {
        byte[] json = Json.write((Object)stubBuilder.build()).getBytes(StandardCharsets.UTF_8);
        Files.write(this.mappingsDir.resolve(name), json, new OpenOption[0]);
    }

    private void assertMappingsDirIsEmpty() {
        this.assertMappingsDirSize(0);
    }

    private void assertMappingsDirContainsOneFile() {
        this.assertMappingsDirSize(1);
    }

    private void assertMappingsDirSize(int size) {
        MatcherAssert.assertThat((Object)this.mappingsDir.toFile().list().length, (Matcher)Matchers.is((Object)size));
    }
}

