/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class StubRequestLoggingAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void logsEventsToNotifierWhenNotDisabled() {
        TestNotifier notifier = new TestNotifier();
        WireMockServer wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().notifier((Notifier)notifier));
        wm.start();
        testClient = new WireMockTestClient(wm.port());
        wm.stubFor(WireMock.get((String)"/log-me").willReturn(WireMock.ok((String)"body text")));
        testClient.get("/log-me", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)notifier.infoMessages.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)notifier.infoMessages.get(0), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Request received:"), (Matcher)Matchers.containsString((String)"/log-me"), (Matcher)Matchers.containsString((String)"body text")));
    }

    @Test
    public void doesNotLogEventsToNotifierWhenDisabled() {
        TestNotifier notifier = new TestNotifier();
        WireMockServer wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().stubRequestLoggingDisabled(true).notifier((Notifier)notifier));
        wm.start();
        testClient = new WireMockTestClient(wm.port());
        wm.stubFor(WireMock.get((String)"/log-me").willReturn(WireMock.ok((String)"body")));
        testClient.get("/log-me", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)notifier.infoMessages.size(), (Matcher)Matchers.is((Object)0));
    }

    public static class TestNotifier
    implements Notifier {
        final List<String> infoMessages = new ArrayList<String>();

        public void info(String message) {
            this.infoMessages.add(message);
        }

        public void error(String message) {
        }

        public void error(String message, Throwable t) {
        }
    }
}

