/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.TemplateModelDataProviderExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TemplateModelDataProviderExtensionTest {
    @RegisterExtension
    public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().templatingEnabled(true).globalTemplating(true).extensions(new Extension[]{new TemplateModelDataProviderExtension(){

        public Map<String, Object> provideTemplateModelData(ServeEvent serveEvent) {
            return Map.of("customData", Map.of("path", serveEvent.getRequest().getUrl()));
        }

        public String getName() {
            return "custom-model-data";
        }
    }})).build();
    WireMockTestClient client;

    @BeforeEach
    void init() {
        this.client = new WireMockTestClient(this.wm.getPort());
    }

    @Test
    void appliesHelpersFromProvider() {
        this.wm.stubFor(WireMock.get((String)"/things").willReturn(WireMock.ok((String)"{{{ customData.path }}}")));
        WireMockResponse response = this.client.get("/things", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"/things"));
    }
}

