/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.Network;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WarDeploymentAcceptanceTest {
    private Server jetty;
    private WireMockTestClient testClient;

    @BeforeEach
    public void init() throws Exception {
        String webAppRootPath = TestFiles.sampleWarRootDir() + "/src/main/webapp";
        WebAppContext context = new WebAppContext(webAppRootPath, "/wiremock");
        int port = this.attemptToStartOnRandomPort(context);
        WireMock.configureFor((String)"localhost", (int)port, (String)"/wiremock");
        this.testClient = new WireMockTestClient(port);
    }

    private int attemptToStartOnRandomPort(WebAppContext context) throws Exception {
        int port;
        int attemptsRemaining = 3;
        while (true) {
            port = Network.findFreePort();
            this.jetty = new Server(port);
            this.jetty.setHandler((Handler)context);
            try {
                this.jetty.start();
            }
            catch (Exception e) {
                if (--attemptsRemaining > 0) continue;
                throw e;
            }
            break;
        }
        return port;
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.jetty.stop();
        WireMock.configure();
    }

    @Test
    public void servesBakedInStubResponse() {
        WireMockResponse response = this.testClient.get("/wiremock/api/mytest", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"YES"));
    }

    @Test
    public void acceptsAndReturnsStubMapping() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/war/stub")).willReturn(WireMock.aResponse().withStatus(200).withBody("War stub OK")));
        MatcherAssert.assertThat((Object)this.testClient.get("/wiremock/war/stub", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"War stub OK"));
    }

    @Test
    public void tryingToShutDownGives500() {
        try {
            WireMock.shutdownServer();
            Assertions.fail((String)"Expected a VerificationException");
        }
        catch (VerificationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"500"));
        }
    }

    @Test
    public void tryingToSaveMappingsGives500() {
        try {
            WireMock.saveAllMappings();
            Assertions.fail((String)"Expected a VerificationException");
        }
        catch (VerificationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"500"));
        }
    }
}

