/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.LimitAndOffsetPaginator;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LimitAndOffsetPaginatorTest {
    @Test
    public void returnsWholeListWhenBothParametersAreNull() {
        List source = Ints.asList((int[])new int[]{1, 2, 3, 4, 5});
        LimitAndOffsetPaginator paginator = new LimitAndOffsetPaginator(source, null, null);
        List result = paginator.select();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)Ints.asList((int[])new int[]{1, 2, 3, 4, 5})));
    }

    @Test
    public void returnsEmptyListWhenSourceIsEmpty() {
        List source = Collections.emptyList();
        LimitAndOffsetPaginator paginator = new LimitAndOffsetPaginator(source, null, null);
        List result = paginator.select();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is(Collections.emptyList()));
    }

    @Test
    public void returnsTruncatedListFromStartWhenOnlyLimitIsSpecified() {
        List source = Ints.asList((int[])new int[]{1, 2, 3, 4, 5});
        LimitAndOffsetPaginator paginator = new LimitAndOffsetPaginator(source, Integer.valueOf(3), null);
        List result = paginator.select();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)Ints.asList((int[])new int[]{1, 2, 3})));
    }

    @Test
    public void returnsFromOffSetToTheEndWhenOnlyOffsetIsSpecified() {
        List source = Ints.asList((int[])new int[]{1, 2, 3, 4, 5});
        LimitAndOffsetPaginator paginator = new LimitAndOffsetPaginator(source, null, Integer.valueOf(2));
        List result = paginator.select();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)Ints.asList((int[])new int[]{3, 4, 5})));
    }

    @Test
    public void returnsRangeWhenBothAreSpecified() {
        List source = Ints.asList((int[])new int[]{1, 2, 3, 4, 5});
        LimitAndOffsetPaginator paginator = new LimitAndOffsetPaginator(source, Integer.valueOf(3), Integer.valueOf(1));
        List result = paginator.select();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)Ints.asList((int[])new int[]{2, 3, 4})));
    }

    @Test
    public void returnsToEndOfListWhenTopBoundIsGreaterThanListSize() {
        List source = Ints.asList((int[])new int[]{1, 2, 3, 4, 5});
        LimitAndOffsetPaginator paginator = new LimitAndOffsetPaginator(source, Integer.valueOf(7), Integer.valueOf(3));
        List result = paginator.select();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)Ints.asList((int[])new int[]{4, 5})));
    }

    @Test
    public void rejectsNegativeLimit() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LimitAndOffsetPaginator(Collections.emptyList(), Integer.valueOf(-1), Integer.valueOf(3)));
    }

    @Test
    public void rejectsNegativeOffset() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LimitAndOffsetPaginator(Collections.emptyList(), Integer.valueOf(0), Integer.valueOf(-10)));
    }
}

