/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.archunit;

import com.github.tomakehurst.wiremock.WireMockJUnitRuleTest;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.junit.WireMockRuleFailOnUnmatchedRequestsTest;
import com.github.tomakehurst.wiremock.junit.WireMockStaticRule;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.junit.AnalyzeClasses;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.FieldsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.runner.RunWith;

@AnalyzeClasses(packagesOf={WireMockServer.class}, importOptions={ImportOption.DoNotIncludeArchives.class, ImportOption.DoNotIncludeJars.class})
class JUnit4DetectionTest {
    private static final List<Class<?>> excluded = Stream.of(WireMockClassRule.class, WireMockRule.class, WireMockStaticRule.class, JUnit4DetectionTest.class, WireMockJUnitRuleTest.class, WireMockRuleFailOnUnmatchedRequestsTest.class).collect(Collectors.toList());
    private static final DescribedPredicate<? super JavaClass> EXCLUDE_WIREMOCKJUNITRULETEST = DescribedPredicate.describe((String)"exclude WireMockJUnitRuleTest", clazz -> !excluded.stream().anyMatch(excl -> clazz.getName().contains(excl.getSimpleName())));
    private static final String REASON = "we want to migrate to JUnit Jupiter";
    @ArchTest
    static ArchRule junit4PackageShouldNotBeUsed = ((ArchRule)((ClassesShouldConjunction)ArchRuleDefinition.noClasses().that(EXCLUDE_WIREMOCKJUNITRULETEST).should().dependOnClassesThat().resideInAnyPackage(new String[]{"org.junit"})).as("org.junit should not be used")).because("we want to migrate to JUnit Jupiter");
    @ArchTest
    static ArchRule junit4RunWithShouldNotBeUsed = ((ArchRule)ArchRuleDefinition.classes().that(EXCLUDE_WIREMOCKJUNITRULETEST).should().notBeAnnotatedWith(RunWith.class).as("RunWith should not be used")).because("we want to migrate to JUnit Jupiter");
    @ArchTest
    static ArchRule junit4ClassRuleShouldNotBeUsed = ((ArchRule)((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areDeclaredInClassesThat(EXCLUDE_WIREMOCKJUNITRULETEST)).should().notBeAnnotatedWith(ClassRule.class)).as("ClassRule should not be used")).because("we want to migrate to JUnit Jupiter");
    @ArchTest
    static ArchRule junit4RuleShouldNotBeUsed = ((ArchRule)((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areDeclaredInClassesThat(EXCLUDE_WIREMOCKJUNITRULETEST)).should().notBeAnnotatedWith(Rule.class)).as("Rule should not be used")).because("we want to migrate to JUnit Jupiter");

    JUnit4DetectionTest() {
    }
}

