/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.BasicAuthenticator;
import com.github.tomakehurst.wiremock.security.ClientAuthenticator;
import com.github.tomakehurst.wiremock.security.ClientBasicAuthenticator;
import com.github.tomakehurst.wiremock.security.ClientTokenAuthenticator;
import com.github.tomakehurst.wiremock.security.NotAuthorisedException;
import com.github.tomakehurst.wiremock.security.TokenAuthenticator;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientAuthenticationAcceptanceTest {
    private WireMockServer server;
    private WireMock goodClient;
    private WireMock badClient;

    @AfterEach
    public void stopServer() {
        this.server.stop();
    }

    @Test
    public void supportsCustomAuthenticator() {
        this.initialise(request -> request.containsHeader("X-Magic-Header"), () -> Collections.singletonList(HttpHeader.httpHeader((String)"X-Magic-Header", (String[])new String[]{"blah"})));
        WireMockTestClient noAuthClient = new WireMockTestClient(this.server.port());
        MatcherAssert.assertThat((Object)noAuthClient.get("/__admin/mappings", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)noAuthClient.get("/__admin/mappings", TestHttpHeader.withHeader("X-Magic-Header", "anything")).statusCode(), (Matcher)Matchers.is((Object)200));
        this.goodClient.getServeEvents();
    }

    @Test
    public void supportsBasicAuthenticator() {
        this.initialise((Authenticator)new BasicAuthenticator(new BasicCredentials[]{new BasicCredentials("user1", "password1"), new BasicCredentials("user2", "password2")}), (ClientAuthenticator)new ClientBasicAuthenticator("user1", "password1"));
        this.goodClient.getServeEvents();
    }

    @Test
    public void throwsNotAuthorisedExceptionWhenWrongBasicCredentialsProvided() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            this.initialise((Authenticator)new BasicAuthenticator(new BasicCredentials[]{new BasicCredentials("user1", "password1"), new BasicCredentials("user2", "password2")}), (ClientAuthenticator)new ClientBasicAuthenticator("user1", "password1"));
            this.badClient = WireMock.create().port(this.server.port()).authenticator((ClientAuthenticator)new ClientBasicAuthenticator("user1", "wrong_password")).build();
            this.badClient.getServeEvents();
        });
    }

    @Test
    public void supportsBasicAuthenticatorViaStaticDsl() {
        this.initialise((Authenticator)new BasicAuthenticator(new BasicCredentials[]{new BasicCredentials("user1", "password1"), new BasicCredentials("user2", "password2")}), (ClientAuthenticator)new ClientBasicAuthenticator("user2", "password2"));
        WireMockTestClient client = new WireMockTestClient(this.server.port());
        WireMock.configureFor((WireMock)this.goodClient);
        WireMock.getAllServeEvents();
        MatcherAssert.assertThat((Object)client.get("/__admin/requests", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    public void supportsShorthandBasicAuthWithHttps() {
        this.server = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().basicAdminAuthenticator("user", "password"));
        this.server.start();
        this.goodClient = WireMock.create().port(this.server.httpsPort()).https().basicAuthenticator("user", "password").build();
        this.goodClient.getServeEvents();
    }

    @Test
    public void canRequireHttpsOnAdminApi() {
        this.server = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().basicAdminAuthenticator("user", "password").requireHttpsForAdminApi());
        this.server.start();
        WireMockTestClient client = new WireMockTestClient(this.server.port());
        String authHeader = new BasicCredentials("user", "password").asAuthorizationHeaderValue();
        WireMockResponse response = client.get("/__admin/requests", TestHttpHeader.withHeader("Authorization", authHeader));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"HTTPS is required for accessing the admin API"));
    }

    @Test
    public void supportsTokenAuthenticatorViaStaticDsl() {
        String TOKEN = "my_token_123";
        this.initialise((Authenticator)new TokenAuthenticator("my_token_123"), (ClientAuthenticator)new ClientTokenAuthenticator("my_token_123"));
        WireMockTestClient client = new WireMockTestClient(this.server.port());
        WireMock.configureFor((WireMock)this.goodClient);
        WireMock.getAllServeEvents();
        MatcherAssert.assertThat((Object)client.get("/__admin/requests", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)401));
    }

    private void initialise(Authenticator adminAuthenticator, ClientAuthenticator clientAuthenticator) {
        this.server = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().adminAuthenticator(adminAuthenticator));
        this.server.start();
        this.goodClient = WireMock.create().port(this.server.port()).authenticator(clientAuthenticator).build();
    }
}

