/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class ResponseDefinitionBuilderTest {
    ResponseDefinitionBuilderTest() {
    }

    @Test
    void withTransformerParameterShouldNotChangeOriginalTransformerParametersValue() {
        ResponseDefinition originalResponseDefinition = ResponseDefinitionBuilder.responseDefinition().withTransformerParameter("name", (Object)"original").build();
        ResponseDefinition transformedResponseDefinition = ResponseDefinitionBuilder.like((ResponseDefinition)originalResponseDefinition).but().withTransformerParameter("name", (Object)"changed").build();
        MatcherAssert.assertThat((Object)originalResponseDefinition.getTransformerParameters().getString("name"), (Matcher)Matchers.is((Object)"original"));
        MatcherAssert.assertThat((Object)transformedResponseDefinition.getTransformerParameters().getString("name"), (Matcher)Matchers.is((Object)"changed"));
    }

    @Test
    void likeShouldCreateCompleteResponseDefinitionCopy() {
        ResponseDefinition originalResponseDefinition = ResponseDefinitionBuilder.responseDefinition().withStatus(200).withStatusMessage("OK").withBody("some body").withBase64Body(Base64.getEncoder().encodeToString("some body".getBytes(StandardCharsets.UTF_8))).withBodyFile("some_body.json").withHeader("some header", new String[]{"some value"}).withFixedDelay(Integer.valueOf(100)).withUniformRandomDelay(1, 2).withChunkedDribbleDelay(1, 1000).withFault(Fault.EMPTY_RESPONSE).withTransformers(new String[]{"some transformer"}).withTransformerParameter("some param", (Object)"some value").build();
        ResponseDefinition copiedResponseDefinition = ResponseDefinitionBuilder.like((ResponseDefinition)originalResponseDefinition).build();
        MatcherAssert.assertThat((Object)copiedResponseDefinition, (Matcher)Matchers.is((Object)originalResponseDefinition));
    }

    @Test
    void proxyResponseDefinitionWithoutProxyInformationIsNotInResponseDefinition() {
        ResponseDefinition proxyDefinition = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.domain").build();
        MatcherAssert.assertThat((Object)proxyDefinition.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)proxyDefinition.getProxyUrlPrefixToRemove(), (Matcher)Matchers.nullValue());
    }

    @Test
    void proxyResponseDefinitionWithoutProxyInformationIsNotInResponseDefinitionWithJsonBody() {
        ResponseDefinition proxyDefinition = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.domain").withJsonBody((JsonNode)Json.read((String)"{}", JsonNode.class)).build();
        MatcherAssert.assertThat((Object)proxyDefinition.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)proxyDefinition.getProxyUrlPrefixToRemove(), (Matcher)Matchers.nullValue());
    }

    @Test
    void proxyResponseDefinitionWithoutProxyInformationIsNotInResponseDefinitionWithBinaryBody() {
        ResponseDefinition proxyDefinition = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.domain").withBody(new byte[]{1}).build();
        MatcherAssert.assertThat((Object)proxyDefinition.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)proxyDefinition.getProxyUrlPrefixToRemove(), (Matcher)Matchers.nullValue());
    }

    @Test
    void proxyResponseDefinitionWithExtraInformationIsInResponseDefinition() {
        ResponseDefinition proxyDefinition = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.domain").withAdditionalRequestHeader("header", "value").withProxyUrlPrefixToRemove("/remove").build();
        MatcherAssert.assertThat((Object)proxyDefinition.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.equalTo((Object)new HttpHeaders((Iterable)Lists.newArrayList((Object[])new HttpHeader[]{new HttpHeader("header", new String[]{"value"})}))));
        MatcherAssert.assertThat((Object)proxyDefinition.getProxyUrlPrefixToRemove(), (Matcher)Matchers.equalTo((Object)"/remove"));
    }

    @Test
    void proxyResponseDefinitionWithExtraInformationIsInResponseDefinitionWithJsonBody() {
        ResponseDefinition proxyDefinition = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.domain").withAdditionalRequestHeader("header", "value").withProxyUrlPrefixToRemove("/remove").withJsonBody((JsonNode)Json.read((String)"{}", JsonNode.class)).build();
        MatcherAssert.assertThat((Object)proxyDefinition.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.equalTo((Object)new HttpHeaders((Iterable)Lists.newArrayList((Object[])new HttpHeader[]{new HttpHeader("header", new String[]{"value"})}))));
        MatcherAssert.assertThat((Object)proxyDefinition.getProxyUrlPrefixToRemove(), (Matcher)Matchers.equalTo((Object)"/remove"));
    }

    @Test
    void proxyResponseDefinitionWithExtraInformationIsInResponseDefinitionWithBinaryBody() {
        ResponseDefinition proxyDefinition = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.domain").withAdditionalRequestHeader("header", "value").withProxyUrlPrefixToRemove("/remove").withBody(new byte[]{1}).build();
        MatcherAssert.assertThat((Object)proxyDefinition.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.equalTo((Object)new HttpHeaders((Iterable)Lists.newArrayList((Object[])new HttpHeader[]{new HttpHeader("header", new String[]{"value"})}))));
        MatcherAssert.assertThat((Object)proxyDefinition.getProxyUrlPrefixToRemove(), (Matcher)Matchers.equalTo((Object)"/remove"));
    }
}

