/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WireMockClientAcceptanceTest {
    private WireMockServer wireMockServer;
    private WireMockTestClient testClient;

    @BeforeEach
    public void init() {
        this.wireMockServer = new WireMockServer(0);
        this.wireMockServer.start();
        WireMock.configureFor((int)this.wireMockServer.port());
        this.testClient = new WireMockTestClient(this.wireMockServer.port());
    }

    @AfterEach
    public void stopServer() {
        this.wireMockServer.stop();
    }

    @Test
    public void buildsMappingWithUrlOnlyRequestAndStatusOnlyResponse() {
        WireMock wireMock = WireMock.create().port(this.wireMockServer.port()).build();
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)this.testClient.get("/my/new/resource", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)304));
    }

    @Test
    public void buildsMappingFromStaticSyntax() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)this.testClient.get("/my/new/resource", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)304));
    }

    @Test
    public void buildsMappingWithUrlOnyRequestAndResponseWithJsonBodyWithDiacriticSigns() {
        WireMock wireMock = WireMock.create().port(this.wireMockServer.port()).build();
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withBody("{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}").withStatus(200)));
        MatcherAssert.assertThat((Object)this.testClient.get("/my/new/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}"));
    }
}

