/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClasspathFileSourceTest {
    ClasspathFileSource classpathFileSource;

    @Test
    public void listsFilesRecursivelyFromJar() {
        this.initForJar();
        List files = this.classpathFileSource.listFilesRecursively();
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{WireMatchers.fileNamed("pom.properties"), WireMatchers.fileNamed("pom.xml")}));
    }

    @Test
    public void listsFilesRecursivelyFromFileSystem() {
        this.initForFileSystem();
        List files = this.classpathFileSource.listFilesRecursively();
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{WireMatchers.fileNamed("one"), WireMatchers.fileNamed("two"), WireMatchers.fileNamed("three"), WireMatchers.fileNamed("four"), WireMatchers.fileNamed("five"), WireMatchers.fileNamed("six")}));
    }

    @Test
    public void readsBinaryFileFromJar() {
        this.initForJar();
        BinaryFile binaryFile = this.classpathFileSource.getBinaryFileNamed("guava/pom.xml");
        MatcherAssert.assertThat((String)"Expected a non zero length file", (Object)binaryFile.readContents().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void readsBinaryFileFromCustomClassLoader() throws MalformedURLException {
        this.initForCustomClassLoader();
        BinaryFile binaryFile = this.classpathFileSource.child("__files").getBinaryFileNamed("stuff.txt");
        MatcherAssert.assertThat((String)"Expected a non zero length file", (Object)binaryFile.readContents().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void readsBinaryFileFromZip() {
        this.classpathFileSource = new ClasspathFileSource("zippeddir");
        BinaryFile binaryFile = this.classpathFileSource.getBinaryFileNamed("zippedfile.txt");
        String contents = new String(binaryFile.readContents());
        MatcherAssert.assertThat((Object)contents, (Matcher)Matchers.containsString((String)"zip"));
    }

    @Test
    public void readsBinaryFileFromZipWithoutMatch() {
        this.classpathFileSource = new ClasspathFileSource("zippeddir");
        try {
            this.classpathFileSource.getBinaryFileNamed("thisWillNotBeFound.txt");
            Assertions.fail((String)"Should have thrown exception.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((String)"Informative error", (Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Was unable to find entry: \"zippeddir/thisWillNotBeFound.txt\", found:"));
        }
    }

    @Test
    public void readsBinaryFileFromFileSystem() {
        this.initForFileSystem();
        BinaryFile binaryFile = this.classpathFileSource.getBinaryFileNamed("subdir/deepfile.json");
        MatcherAssert.assertThat((String)"Expected a non zero length file", (Object)binaryFile.readContents().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void createsChildSource() {
        this.initForFileSystem();
        FileSource child = this.classpathFileSource.child("subdir");
        MatcherAssert.assertThat((Object)child.getPath(), (Matcher)Matchers.is((Object)"filesource/subdir"));
    }

    @Test
    public void correctlyReportsExistence() {
        Assertions.assertTrue((boolean)new ClasspathFileSource("filesource/subdir").exists(), (String)"Expected to exist");
        Assertions.assertTrue((boolean)new ClasspathFileSource("META-INF/maven/com.google.guava").exists(), (String)"Expected to exist");
        Assertions.assertFalse((boolean)new ClasspathFileSource("not/exist").exists(), (String)"Expected not to exist");
    }

    @Test
    public void failsSilentlyOnWrites() {
        this.initForFileSystem();
        this.classpathFileSource.deleteFile("one");
        this.classpathFileSource.writeBinaryFile("any-bytes", new byte[0]);
        this.classpathFileSource.writeTextFile("any-text", "things");
        this.classpathFileSource.createIfNecessary();
    }

    private void initForJar() {
        this.classpathFileSource = new ClasspathFileSource("META-INF/maven/com.google.guava");
    }

    private void initForFileSystem() {
        this.classpathFileSource = new ClasspathFileSource("filesource");
    }

    private void initForCustomClassLoader() throws MalformedURLException {
        URL[] urls = new URL[]{new File("src/main/resources/classpath-filesource.jar").toURI().toURL()};
        URLClassLoader cl = new URLClassLoader(urls);
        this.classpathFileSource = new ClasspathFileSource((ClassLoader)cl, "jar-filesource");
    }
}

