/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContentTypesTest {
    @Test
    public void detectsTextTypesCorrectlyFromFileExtension() {
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"txt"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"json"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"xml"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"html"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"htm"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"yaml"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"csv"));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromExtension((String)"jpg"));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromExtension((String)"png"));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromExtension(null));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromExtension((String)""));
    }

    @Test
    public void detectsTextTypesCorrectlyFromMimeType() {
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/plain"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/html"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/json"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"some-preamble; application/json"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/blah.something+json"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/xml"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/xml"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/xml; utf-8"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/csv"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/x-www-form-urlencoded"));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/octet-stream"));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromMimeType((String)"image/jpeg"));
        Assertions.assertFalse((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/pdf"));
    }

    @Test
    public void detectsTextTypesCorrectlyFromExtensionOrMimeType() {
        Assertions.assertTrue((boolean)ContentTypes.determineIsText((String)"txt", (String)"text/plain"));
        Assertions.assertTrue((boolean)ContentTypes.determineIsText((String)"xml", (String)""));
        Assertions.assertTrue((boolean)ContentTypes.determineIsText((String)"json", null));
        Assertions.assertFalse((boolean)ContentTypes.determineIsText((String)"png", null));
        Assertions.assertFalse((boolean)ContentTypes.determineIsText(null, (String)"image/jpeg"));
    }

    @Test
    public void correctlyDeterminesFileExtensionWhenDotsInPath() {
        String fileExtension = ContentTypes.determineFileExtension((String)"http://some.host/path.with.dots/and/several/segments", (ContentTypeHeader)ContentTypeHeader.absent(), (byte[])new byte[0]);
        MatcherAssert.assertThat((Object)fileExtension, (Matcher)Matchers.is((Object)"txt"));
    }

    @Test
    public void correctlyDeterminesFileExtensionFromUrl() {
        String fileExtension = ContentTypes.determineFileExtension((String)"http://some.host/path.with.dots/image.png", (ContentTypeHeader)ContentTypeHeader.absent(), (byte[])new byte[0]);
        MatcherAssert.assertThat((Object)fileExtension, (Matcher)Matchers.is((Object)"png"));
    }
}

