/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.JettySettings;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JettySettingsTest {
    private static final int number = 1234;
    private static final long longNumber = Long.MAX_VALUE;

    @Test
    public void testBuilderWithValues() {
        JettySettings.Builder builder = JettySettings.Builder.aJettySettings();
        builder.withAcceptors(Integer.valueOf(1234)).withAcceptQueueSize(Integer.valueOf(1234)).withRequestHeaderSize(Integer.valueOf(1234)).withResponseHeaderSize(Integer.valueOf(1234)).withStopTimeout(Long.valueOf(Long.MAX_VALUE)).withIdleTimeout(Long.valueOf(Long.MAX_VALUE));
        JettySettings jettySettings = builder.build();
        this.ensurePresent(jettySettings.getAcceptors());
        this.ensurePresent(jettySettings.getAcceptQueueSize());
        this.ensurePresent(jettySettings.getRequestHeaderSize());
        this.ensurePresent(jettySettings.getResponseHeaderSize());
        this.ensureLongPresent(jettySettings.getStopTimeout());
        this.ensureLongPresent(jettySettings.getIdleTimeout());
    }

    @Test
    public void testBuilderWithNoValues() {
        JettySettings.Builder builder = JettySettings.Builder.aJettySettings();
        JettySettings jettySettings = builder.build();
        Assertions.assertFalse((boolean)jettySettings.getAcceptors().isPresent());
        Assertions.assertFalse((boolean)jettySettings.getAcceptQueueSize().isPresent());
        Assertions.assertFalse((boolean)jettySettings.getRequestHeaderSize().isPresent());
        Assertions.assertFalse((boolean)jettySettings.getStopTimeout().isPresent());
        Assertions.assertFalse((boolean)jettySettings.getIdleTimeout().isPresent());
    }

    private void ensurePresent(Optional<Integer> optional) {
        Assertions.assertTrue((boolean)optional.isPresent());
        Assertions.assertEquals((Integer)1234, (Integer)optional.get());
    }

    private void ensureLongPresent(Optional<Long> optional) {
        Assertions.assertTrue((boolean)optional.isPresent());
        Assertions.assertEquals((Long)Long.MAX_VALUE, (Long)optional.get());
    }
}

