/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ServletContextFileSource;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletContextFileSourceTest {
    private ServletContextFileSource fileSource;

    @BeforeEach
    public void init() {
        this.fileSource = new ServletContextFileSource((ServletContext)new MockServletContext(), "filesource");
    }

    @Test
    public void listsTextFilesRecursively() {
        List files = this.fileSource.listFilesRecursively();
        MatcherAssert.assertThat((Object)files, WireMatchers.hasExactlyIgnoringOrder(WireMatchers.fileNamed("one"), WireMatchers.fileNamed("two"), WireMatchers.fileNamed("three"), WireMatchers.fileNamed("four"), WireMatchers.fileNamed("five"), WireMatchers.fileNamed("six"), WireMatchers.fileNamed("seven"), WireMatchers.fileNamed("eight"), WireMatchers.fileNamed("deepfile.json")));
    }

    @Test
    public void throwsUnsupportedExceptionWhenAttemptingToWrite() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileSource.writeTextFile("filename", "filecontents"));
    }

    @Test
    public void throwsUnsupportedExceptionWhenAttemptingToCreate() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((ServletContextFileSource)this.fileSource).createIfNecessary());
    }

    private static class MockServletContext
    implements ServletContext {
        private MockServletContext() {
        }

        public ServletContext getContext(String uripath) {
            return null;
        }

        public int getMajorVersion() {
            return 0;
        }

        public int getMinorVersion() {
            return 0;
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String getMimeType(String file) {
            return null;
        }

        public Set getResourcePaths(String path) {
            return null;
        }

        public URL getResource(String path) throws MalformedURLException {
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public Enumeration getServlets() {
            return null;
        }

        public Enumeration getServletNames() {
            return null;
        }

        public void log(String msg) {
        }

        public void log(Exception exception, String msg) {
        }

        public void log(String message, Throwable throwable) {
        }

        public String getRealPath(String path) {
            return TestFiles.filePath("filesource");
        }

        public String getServerInfo() {
            return null;
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return null;
        }

        public boolean setInitParameter(String name, String value) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public void setAttribute(String name, Object object) {
        }

        public void removeAttribute(String name) {
        }

        public String getServletContextName() {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public ServletRegistration getServletRegistration(String servletName) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void addListener(String className) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public <T extends EventListener> void addListener(T t) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void declareRoles(String ... roleNames) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String getVirtualServerName() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String getContextPath() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public int getSessionTimeout() {
            return 0;
        }

        public void setSessionTimeout(int sessionTimeout) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String getRequestCharacterEncoding() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void setRequestCharacterEncoding(String encoding) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String getResponseCharacterEncoding() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void setResponseCharacterEncoding(String encoding) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }
}

