/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.crypto;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.crypto.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Objects;

public class InMemoryKeyStore {
    private final Secret password;
    private final KeyStore keyStore;

    public InMemoryKeyStore(KeyStoreType type, Secret password) {
        this.password = Objects.requireNonNull(password, "password");
        this.keyStore = this.initialise(Objects.requireNonNull(type, "type"));
    }

    private KeyStore initialise(KeyStoreType type) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.type);
            keyStore.load(null, this.password.getValue());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            return (KeyStore)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }

    public void addPrivateKey(String alias, KeyPair keyPair, Certificate ... certs) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, keyPair.getPrivate(), this.password.getValue(), certs);
    }

    public void addCertificate(String alias, Certificate cert) throws KeyStoreException {
        this.keyStore.setCertificateEntry(alias, cert);
    }

    public void saveAs(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            try {
                this.keyStore.store(fos, this.password.getValue());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                Exceptions.throwUnchecked((Throwable)e);
            }
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public static enum KeyStoreType {
        JKS("jks");

        private final String type;

        private KeyStoreType(String type) {
            this.type = type;
        }
    }
}

