/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.crypto;

import java.util.Arrays;
import java.util.Objects;

public class Secret
implements AutoCloseable {
    private static final char[] EMPTY_VALUE = new char[0];
    private volatile char[] value;

    public Secret(char[] value) {
        Objects.requireNonNull(value, "Secret value may not be null");
        this.value = Arrays.copyOf(value, value.length);
    }

    public Secret(String value) {
        this(null == value ? null : value.toCharArray());
    }

    public char[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public void close() {
        if (EMPTY_VALUE == this.value) {
            return;
        }
        char[] tempValue = this.value;
        this.value = EMPTY_VALUE;
        Arrays.fill(tempValue, '\u0000');
    }

    public boolean compareTo(String password) {
        if (password == null) {
            return false;
        }
        return Arrays.equals(password.toCharArray(), this.value);
    }
}

