/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.crypto;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.io.IOException;
import sun.security.x509.CertificateVersion;

public enum X509CertificateVersion {
    V1(0),
    V2(1),
    V3(2);

    private final CertificateVersion version;

    private X509CertificateVersion(int version) {
        this.version = X509CertificateVersion.getVersion(version);
    }

    private static CertificateVersion getVersion(int version) {
        try {
            return new CertificateVersion(version);
        }
        catch (IOException e) {
            return (CertificateVersion)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }

    CertificateVersion getVersion() {
        return this.version;
    }
}

